#ifndef TEXT_H
#define TEXT_H

#include "oslib.h"

//Police de caractres
typedef struct			{
	void *fontdata;							//Images des caractres
	short pixelFormat;						//1 = 1 bit (dfaut)
	unsigned char *charWidths;				//Tailles des caractres
	int charWidth;							//Taille des caractres si charWidths est NULL
	int charHeight;							//Hauteur des caractres (constante)
	int lineWidth;							//Nombre d'octets par ligne
	int recentrage;							//A ajouter aux positions pour le dessin du texte
	unsigned char addedSpace;				//Espace ajout entre les caractres sur la texture (permet de faire des caractres plus gros qu'indiqu par charWidths)
} OSL_FONTINFO;

//Fonte charge
typedef struct			{
	OSL_IMAGE *img;							//Images des caractres
	unsigned char *charWidths;				//Tailles des caractres
	unsigned short *charPositions;			//Positions des caractres (y:7, x:9)
	int isCharWidthConstant;				//Pour savoir s'il faut librer charWidth
	int charWidth;
	int charHeight;							//Hauteur des caractres (constante)
	int recentrage;							//A ajouter aux positions pour le dessin du texte
	unsigned char addedSpace;				//Espace ajout entre les caractres sur la texture (permet de faire des caractres plus gros qu'indiqu par charWidths)
} OSL_FONT;

//Fichier .oft (non, pas souvent, Oslib FonT)
typedef struct		{
	char strVersion[12];			// "OSLFont v01"
	unsigned char pixelFormat;		// 1 = 1 bit
	unsigned char variableWidth;	// Si oui les 256 premiers octets de data spcifient la largeur.
	int charWidth, charHeight;		// Tailles moyennes des caractres
	int lineWidth;					// Nombre d'octets par ligne
	unsigned char addedSpace;		//Espace ajout entre les caractres sur la texture (permet de faire des caractres plus gros qu'indiqu par charWidths)
	unsigned char reserved[31];		// Nul
} OSL_FONT_FORMAT_HEADER;

extern OSL_FONT *osl_curFont;

#define oslSetFont(f)		(osl_curFont = f)
#define OSL_TEXT_TEXWIDTH 512
#define OSL_TEXT_TEXDECAL 9
#define OSL_TEXT_CHARPOSXY(f,i)		(f)->charPositions[i]&(OSL_TEXT_TEXWIDTH-1), ((f)->charPositions[i]>>OSL_TEXT_TEXDECAL)*(f)->charHeight


extern void oslInitConsole();
extern OSL_FONT *oslLoadFont(OSL_FONTINFO *fi);
extern OSL_FONT *oslLoadFontFile(const char *filename);
extern void oslDrawChar(int x, int y, unsigned char c);
extern void oslDrawString(int x, int y, const char *str);
extern void oslConsolePrint(const char *str);
extern void oslSetTextColor(OSL_COLOR color);
extern void oslSetBkColor(OSL_COLOR color);
extern void oslDrawTextBox(int x0, int y0, int x1, int y1, const char *text, int format);
extern void oslDeleteFont(OSL_FONT *f);

extern int osl_consolePosX, osl_consolePosY;
extern OSL_FONT *osl_curFont;
extern OSL_FONT *osl_sceFont;
extern int osl_consolePosX, osl_consolePosY, osl_consoleOk;
extern OSL_FONTINFO osl_sceFontInfo;

#endif
