#ifndef VFPU_H
#define VFPU_H

#include "vfpu_ops.h"

extern float vfpu_vars[4] __attribute__((aligned(64)));

//r = f1 + f2
extern float vfpu_add(float f1, float f2);
//r = f1 - f2
extern float vfpu_sub(float f1, float f2);
//r = f1 * f2
extern float vfpu_mul(float f1, float f2);
//r = f1 / f2
extern float vfpu_div(float f1, float f2);
//r = (int)v
extern int vfpu_f2i(float v);
//r = (float)v
extern float vfpu_i2f(int v);
//r = sin(f1)*f2
extern float vfpu_sini(int f1, int f2);
//r = cos(f1)*f2
extern float vfpu_cosi(int f1, int f2);
//r = (int)(f1 - f2)
extern int vfpu_isubf(float f1, float f2);

//Int to float
#define vi2f_s(vfpu_rd,vfpu_rs,scale) (0xd2800000 | ((scale) << 16) | ((vfpu_rs) << 8) | (vfpu_rd)) 
//Float to int
#define vf2in_s(vfpu_rd,vfpu_rs,scale) (0xd2000000 | ((scale) << 16) | ((vfpu_rs) << 8) | (vfpu_rd))

#endif
