/*
	Based on PSPAUDIOLIB
 */
#ifndef AUDIO_H
#define AUDIO_H

#ifdef __cplusplus
extern "C" {
#endif

#define OSL_NUM_AUDIO_CHANNELS 8
#define OSL_NUM_AUDIO_SAMPLES 512
#define OSL_VOLUME_MAX 0x8000
//256 octets de buffering en streaming
#define OSL_AUDIOSTREAM_BUFFER_SIZE 256

/*
	Ressources alloues  un son:
	Commun
	s (OSL_SOUND)
	
	Fichier WAV
		Commun
			s->dataplus (WAV_SRC)
		Stream
			s->dataplus (WAV_SRC)
				fp (FILE)
		Normal
			s->dataplus (WAV_SRC)
				database (malloc: s->size)
	Fichier ADPCM
		Commun
			s->dataplus (OSL_ADGlobals)
		Stream
			s->data (FILE)
		Normal
			s->data (malloc: s->size)
*/

typedef struct OSL_SOUND		{
	char filename[64];
	void *data, *dataplus;
	int baseoffset;				//Offset de base dans le fichier (sans l'en-tte)
	int format, divider, size, mono, isStreamed;
	int suspendNumber;
	int (*endCallback)(struct OSL_SOUND*, int);
	u8 userdata[32];
} OSL_SOUND;

typedef struct {
  int active;
  int threadhandle;
  int handle;
  int volumeleft;
  int volumeright;
  void (*callback)(unsigned int channel, void *buf, unsigned int reqn);
} osl_audio_channelinfo;

extern volatile int osl_audioActive[OSL_NUM_AUDIO_CHANNELS], osl_audioBusy[OSL_NUM_AUDIO_CHANNELS];

typedef int (* oslAudioThreadfunc_t)(int args, void *argp);

extern int  oslInitAudio();
extern void oslDeinitAudio();
//extern void oslClearAudio();

extern void oslSetChannelVolume(int channel, int left, int right);
extern void oslSetChannelCallback(int channel, void *callback);
extern int  oslAudioOutBlocking(unsigned int channel, unsigned int vol1, unsigned int vol2, void *buf);
extern void oslAudioDeleteChannel(int i);
extern int oslAudioCreateChannel(int i, int format);
extern int oslAudioRecreateChannel(int i, int format);
extern int oslGetSoundChannel(OSL_SOUND *s);
extern void oslStopSound(OSL_SOUND *s);
extern void oslPauseSound(OSL_SOUND *s, int pause);
//A appeler en boucle lorsqu'on a du streaming et que la PSP peut passer en veille
extern void oslAudioVSync();
extern int oslSoundLoopFunc(OSL_SOUND *s, int voice);
#define oslSetSoundEndCallback(s, fct)  (s->endCallback = (fct))
#define oslSetSoundLoop(s,loop)			oslSetSoundEndCallback(s, (loop)?oslSoundLoopFunc:NULL)

typedef struct {
        short l, r;
} sample_stereo_t;

typedef struct {
        short m;
} sample_mono_t;

enum {OSL_FMT_NONE=0, OSL_FMT_ADPCM};
enum {OSL_FMT_MASK=0xff};
enum {OSL_FMT_WAV=0x100};									//Fichier wav
enum {OSL_FMT_MONO=0, OSL_FMT_STEREO=0x200,OSL_FMT_STREAM=0x400};
enum {OSL_FMT_44K=0, OSL_FMT_22K=1, OSL_FMT_11K=2};

//Le format BGM
typedef struct			{
	char strVersion[11];				// "OSLBGM v01"
	int format;							// Toujours 1
	int sampleRate;						// Taux d'chantillonnage
	unsigned char nbChannels;			// Mono ou stro
	unsigned char reserved[32];			// Rserv
} BGM_FORMAT_HEADER;

//Fonctions
extern OSL_SOUND *oslLoadSoundFile(const char *filename, int stream);
extern void oslDeleteSound(OSL_SOUND *s);
extern void oslPlaySound(OSL_SOUND *s, int voice);

#ifdef __cplusplus
}
#endif

#endif

