#include "../oslib.h"
#include "../png.h"
#include "../pngconf.h"
#include "../zlibinterface.h"
#include "../zlib.h"
#include "../zconf.h"

//Lecture / criture des PNG
void oslPngReadFn(png_structp png_ptr, png_bytep data, png_size_t length)			{
	SceUID *f = (SceUID*)png_get_io_ptr(png_ptr);
	sceIoRead(*f, data, length);
}

void oslPngFlushFn(png_structp png_ptr)			{
}

OSL_IMAGE *oslLoadImageFilePNG(char *filename, int location, int pixelFormat)
{
	const size_t	nSigSize=8;
	u8				signature[ nSigSize ];
	OSL_IMAGE		*p_texture = NULL;
	SceUID f;

	f = sceIoOpen(filename, PSP_O_RDONLY, 0777);
	if (f < 0)
		return NULL;

	if ( sceIoRead(f, signature, sizeof( u8 ) * nSigSize) == 0 )
	{
		goto error;
	}

	if ( png_check_sig( signature, nSigSize ) == 0 )
	{
		goto error;
	}

	png_struct *	pPngStruct = png_create_read_struct( PNG_LIBPNG_VER_STRING, NULL, NULL, NULL );

	if ( pPngStruct == NULL)
	{
		goto error;
	}

	png_info *	pPngInfo = png_create_info_struct( pPngStruct );

	if ( pPngInfo == NULL )
	{
		png_destroy_read_struct( &pPngStruct, NULL, NULL );
		goto error;
	}

	if ( setjmp( pPngStruct->jmpbuf ) != 0 )
	{
		png_destroy_read_struct( &pPngStruct, NULL, NULL );
		goto error;
	}
	
	png_set_read_fn(pPngStruct, &f, (png_rw_ptr)oslPngReadFn);
//	png_init_io( pPngStruct, &f );
	png_set_sig_bytes( pPngStruct, nSigSize );
	png_read_png( pPngStruct, pPngInfo, PNG_TRANSFORM_STRIP_16 | PNG_TRANSFORM_PACKING | PNG_TRANSFORM_EXPAND | PNG_TRANSFORM_BGR, NULL );

	png_uint_32 width = pPngInfo->width;
	png_uint_32 height = pPngInfo->height;
	int color_type = pPngInfo->color_type;

	png_byte **pRowTable = pPngInfo->row_pointers;
	unsigned char r=0, g=0, b=0, a=0;

	p_texture = oslCreateImage(width, height, location, pixelFormat);
	if (p_texture)
	{
			u32 *p_dest4 = (u32*)p_texture->data;
			u16 *p_dest2 = (u16*)p_texture->data;
			u32 x, y;

			for ( y = 0; y < height; ++y )
			{
				const png_byte *	pRow = pRowTable[ y ];

				for ( x = 0; x < width; ++x )
				{
					switch ( color_type )
					{
					case PNG_COLOR_TYPE_GRAY:
						r = g = b = *pRow++;
						if ( r == 0 && g == 0 && b == 0 )	a = 0x00;
						else								a = 0xff;
						break;
					case PNG_COLOR_TYPE_GRAY_ALPHA:
						r = g = b = *pRow++;
						if ( r == 0 && g == 0 && b == 0 )	a = 0x00;
						else								a = 0xff;
						pRow++;
						break;
					case PNG_COLOR_TYPE_RGB:
						b = *pRow++;
						g = *pRow++;
						r = *pRow++;
						if (osl_colorKeyEnabled && 
							r == (osl_colorKeyValue&0xff) &&
							g == ((osl_colorKeyValue>>8)&0xff) &&
							b == ((osl_colorKeyValue>>16)&0xff))
								a = 0, r = 0, g = 0, b = 0;
						else
								a = 0xff;
						break;
					case PNG_COLOR_TYPE_RGB_ALPHA:
						b = *pRow++;
						g = *pRow++;
						r = *pRow++;
						a = *pRow++;
						break;
					}

					if (pixelFormat == OSL_PF_8888)
						p_dest4[x] = RGBA(r,g,b,a);
					else if (pixelFormat == OSL_PF_5650)
						p_dest2[x] = RGB16(r,g,b);
					else if (pixelFormat == OSL_PF_5551)
						p_dest2[x] = RGBA15(r,g,b,a);
					else if (pixelFormat == OSL_PF_4444)
						p_dest2[x] = RGBA12(r,g,b,a);
				}

				p_dest2 += ( p_texture->realSizeX );
				p_dest4 += ( p_texture->realSizeX );
			}
		oslUncacheImage(p_texture);
	}

	png_destroy_read_struct( &pPngStruct, &pPngInfo, NULL );
error:
	sceIoClose(f);
	return p_texture;
}
