/*
 * Using parts of pspaudiolib.
 *
 * Copyright (c) 2005 Adresd
 * Copyright (c) 2005 Marcus R. Brown <mrbrown@ocgnet.org>
 *
 * Licensed under the BSD license, see LICENSE in PSPSDK root for details.
 *
 */

#include <stdlib.h>
#include <string.h>
#ifdef PSP
	#include <pspthreadman.h>
	#include <pspaudio.h>
#endif

#include "oslib.h"
#include "audio.h"

/*
	*************************
*/

//Dplac d'aprs #include "readwav.h"
typedef struct		{
	void *data, *dataplus;
	int format, divider, size, mono, isStreamed;
	int volumeLeft, volumeRight;
	OSL_SOUND *sound;
} OSL_AUDIO_VOICE;

OSL_AUDIO_VOICE osl_audioVoices[OSL_NUM_AUDIO_CHANNELS];

int suspendNumber=0;
static int audio_ready=0;
static short audio_sndbuf[OSL_NUM_AUDIO_CHANNELS][2][OSL_NUM_AUDIO_SAMPLES][2];
long osl_filesave[OSL_NUM_AUDIO_CHANNELS];

static osl_audio_channelinfo AudioStatus[OSL_NUM_AUDIO_CHANNELS];

volatile int osl_audioActive[OSL_NUM_AUDIO_CHANNELS];

void oslSetChannelVolume(int channel, int left, int right)
{
  osl_audioVoices[channel].volumeRight = right;
  osl_audioVoices[channel].volumeLeft  = left;
}

void oslAudioChannelThreadCallback(int channel, void *buf, unsigned int reqn)
{
	void (*callback)(unsigned int channel, void *buf, unsigned int reqn);
	callback=AudioStatus[channel].callback;
}


void oslAudioSetChannelCallback(int channel, void *callback)
{
	AudioStatus[channel].callback = (void(*)(unsigned int, void*, unsigned int))callback;
}

int oslAudioOutBlocking(unsigned int channel, unsigned int vol1, unsigned int vol2, void *buf)
{
	if (!audio_ready) return -1;
	if (channel>=OSL_NUM_AUDIO_CHANNELS) return -1;
	if (vol1>OSL_VOLUME_MAX) vol1=OSL_VOLUME_MAX;
	if (vol2>OSL_VOLUME_MAX) vol2=OSL_VOLUME_MAX;
	return sceAudioOutputPannedBlocking(AudioStatus[channel].handle,vol1,vol2,buf);
}

static int oslAudioChannelThread(int args, void *argp)
{
	volatile int bufidx=0;
	int channel=*(int *)argp;

	while (osl_audioActive[channel]>0) {
		void *bufptr=&audio_sndbuf[channel][bufidx];
		void (*callback)(unsigned int channel, void *buf, unsigned int reqn);
		callback=AudioStatus[channel].callback;
		//NE SERT A RIEN, NE FONCTIONNE PAS
		if (callback && osl_audioActive[channel]==1) {
			callback(channel, bufptr, OSL_NUM_AUDIO_SAMPLES);
		} else {
			unsigned int *ptr = (unsigned int*)bufptr;
			int i;
			for (i=0; i<OSL_NUM_AUDIO_SAMPLES; ++i) *(ptr++)=0;
		}
		oslAudioOutBlocking(channel,osl_audioVoices[channel].volumeLeft,osl_audioVoices[channel].volumeRight,bufptr);
		bufidx=(bufidx?0:1);
	}
	osl_audioActive[channel]=-2;				//Signale qu'on a termin. Si le recreatechannel se produit juste entre le test (>0) et ceci, on n'aura pas de son!
	//Fin
	AudioStatus[channel].threadhandle = -1;
	AudioStatus[channel].callback=NULL;
	if (AudioStatus[channel].handle != -1) {
		sceAudioChRelease(AudioStatus[channel].handle);
		AudioStatus[channel].handle = -1;
	}
	osl_audioVoices[channel].sound = NULL;
	osl_audioActive[channel]=0;
	sceKernelExitDeleteThread(0);
	return 0;
}



/******************************************************************************/

/*void oslClearAudio()
{
	int i;
	audio_ready=0;

	for (i=0; i<OSL_NUM_AUDIO_CHANNELS; i++) {
		osl_audioActive[i]=0;
		if (AudioStatus[i].threadhandle != -1) {
			sceKernelWaitThreadEnd(AudioStatus[i].threadhandle,NULL);
			sceKernelDeleteThread(AudioStatus[i].threadhandle);
		}
		AudioStatus[i].threadhandle = -1;
		osl_audioVoices[i].sound = NULL;
	}

	for (i=0; i<OSL_NUM_AUDIO_CHANNELS; i++) {
		if (AudioStatus[i].handle != -1) {
			sceAudioChRelease(AudioStatus[i].handle);
			AudioStatus[i].handle = -1;
		}
	}
}*/

void oslAudioDeleteChannel(int i)
{
	osl_audioActive[i]=-1;
/*	if (AudioStatus[i].threadhandle != -1) {
		sceKernelWaitThreadEnd(AudioStatus[i].threadhandle,NULL);
		sceKernelDeleteThread(AudioStatus[i].threadhandle);
	}
	AudioStatus[i].threadhandle = -1;

	AudioStatus[i].callback=NULL;
	if (AudioStatus[i].handle != -1) {
		sceAudioChRelease(AudioStatus[i].handle);
		AudioStatus[i].handle = -1;
	}
	osl_audioVoices[i].sound = NULL;*/
}

int oslAudioCreateChannel(int i, int format)
{
	int ret;
	int failed=0;
	char str[32];

    AudioStatus[i].handle = -1;
    AudioStatus[i].threadhandle = -1;
    AudioStatus[i].volumeright = OSL_VOLUME_MAX;
    AudioStatus[i].volumeleft  = OSL_VOLUME_MAX;
    AudioStatus[i].callback = 0;

	if ((AudioStatus[i].handle = sceAudioChReserve(-1, OSL_NUM_AUDIO_SAMPLES, format))<0)			{
		failed=1;
	}

	if (failed) {
		if (AudioStatus[i].handle != -1) 
			sceAudioChRelease(AudioStatus[i].handle);
		AudioStatus[i].handle = -1;
		return -1;
	}
	audio_ready = 1;
	osl_audioActive[i]=1;
	strcpy(str,"audiot0");
	str[6]='0'+i;
	AudioStatus[i].threadhandle = sceKernelCreateThread(str,(SceKernelThreadEntry)&oslAudioChannelThread,0x12,0x10000,0,NULL);
	if (AudioStatus[i].threadhandle < 0) {
		AudioStatus[i].threadhandle = -1;
		failed=1;
	}
	ret=sceKernelStartThread(AudioStatus[i].threadhandle,sizeof(i),&i);
	if (ret!=0) {
		failed=1;
	}

	if (failed) {
		osl_audioActive[i]=0;
		if (AudioStatus[i].threadhandle != -1) {
			sceKernelWaitThreadEnd(AudioStatus[i].threadhandle,NULL);
			sceKernelDeleteThread(AudioStatus[i].threadhandle);
		}
		AudioStatus[i].threadhandle = -1;
		return -1;
	}
	return 0;
}

int oslAudioRecreateChannel(int i, int format)
{
/*	int failed=0;
	if (AudioStatus[i].handle != -1) {
		sceAudioChRelease(AudioStatus[i].handle);
		AudioStatus[i].handle = -1;
	}

	if ((AudioStatus[i].handle = sceAudioChReserve(-1, OSL_NUM_AUDIO_SAMPLES, format))<0)			{
		failed=1;
	}

	if (failed) {
		if (AudioStatus[i].handle != -1) 
			sceAudioChRelease(AudioStatus[i].handle);
		AudioStatus[i].handle = -1;
		return -1;
	}*/
	sceAudioChangeChannelConfig(i, format);
	osl_audioActive[i]=1;
	return 0;
}

int oslGetSoundChannel(OSL_SOUND *s)		{
	int i;
	for (i=0; i<OSL_NUM_AUDIO_CHANNELS; i++)		{
		if (osl_audioVoices[i].sound == s)
			return i;
	}
	return -1;
}

// ------------------------------------------

#include "readwav.h"

typedef struct ADGlobals
{
	const unsigned char *data;
	int last_sample;
	int last_index;
} OSL_ADGlobals;

void oslStartAD(OSL_ADGlobals *ad, const unsigned char *data)
{
	ad->data = data;
	ad->last_sample = 0;
	ad->last_index = 0;
}

void oslRepriseAD(OSL_ADGlobals *ad, const unsigned char *data)
{
	ad->data = data;
}


static const signed char ima9_step_indices[16] =
{
  -1, -1, -1, -1, 2, 4, 7, 12,
  -1, -1, -1, -1, 2, 4, 7, 12
};

const unsigned short ima_step_table[89] =
{
      7,    8,    9,   10,   11,   12,   13,   14,   16,   17,
     19,   21,   23,   25,   28,   31,   34,   37,   41,   45,
     50,   55,   60,   66,   73,   80,   88,   97,  107,  118,
    130,  143,  157,  173,  190,  209,  230,  253,  279,  307,
    337,  371,  408,  449,  494,  544,  598,  658,  724,  796,
    876,  963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066,
   2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358,
   5894, 6484, 7132, 7845, 8630, 9493,10442,11487,12635,13899,
  15289,16818,18500,20350,22385,24623,27086,29794,32767
};

static inline int ima9_rescale(int step, unsigned int code)
{
  /* 0,1,2,3,4,5,6,9 */
  int diff = step >> 3;
  if(code & 1)
    diff += step >> 2;
  if(code & 2)
    diff += step >> 1;
  if(code & 4)
    diff += step;
  if((code & 7) == 7)
    diff += step >> 1;
  if(code & 8)
    diff = -diff;
  return diff;
}

short *oslDecodeADMono(OSL_ADGlobals *ad, short *dst, const unsigned char *src, unsigned int len, unsigned int samples, unsigned int streaming)
{
  int last_sample = ad->last_sample;
  int index = ad->last_index;
  unsigned int by = 0, i;
  unsigned char *streambuffer=NULL;
  if (streaming)		{
	streambuffer = (unsigned char*)alloca(len>>1);
	sceIoRead((SceUID)src, streambuffer, len>>1);
  }

  while(len > 0)
  {
    int step, diff;
    unsigned int code;

    if(index < 0)
      index = 0;
    if(index > 88)
      index = 88;
    step = ima_step_table[index];

    if(len & 1)
      code = by >> 4;
    else
    {
		if (streaming)
			by = *streambuffer++;
		else
			by = *src++;
		code = by & 0x0f;
    }

    diff = ima9_rescale(step, code);
    index += ima9_step_indices[code & 0x07];

    last_sample += diff;
    if(last_sample < -32768)
      last_sample = -32768;
    if(last_sample > 32767)
      last_sample = 32767;

	//Deux chantillons sur 2 voies
	for (i=0;i<samples;i++)		{
		*dst++ += last_sample;
	}

    len--;
  }

  ad->last_index = index;
  ad->last_sample = last_sample;
  ad->data = src;
  return dst;
}

void oslDecodeWav(unsigned int i, void* buf, unsigned int length)		{
	int j, k, samples=1<<(osl_audioVoices[i].divider);
	unsigned short *data = (unsigned short*)buf, cur1, cur2;
	WAVE_SRC *wav = (WAVE_SRC*)osl_audioVoices[i].dataplus;
	unsigned char *streambuffer;
	int len;
	if (wav->stream)		{
		//Longueur du segment  lire sur la MS -> 16 bits = *2
		len = (length * wav->fmt.bits_sample) >> 3;
		if (samples == 1)
			len <<= 1;
		else	{
			len>>=osl_audioVoices[i].divider;
		}
		if (osl_audioVoices[i].mono == 0)			//Stro
			len <<= 1;
		streambuffer = (unsigned char*)alloca(len);
		sceIoRead(wav->fp, streambuffer, len);
		wav->streambuffer = streambuffer;
	}
	

	if (samples == 1)			{
		if (osl_audioVoices[i].mono == 0)
			length<<=1;
		for (j=0;j<length;j++)			{
			*data++ = get_next_wav_sample(wav);
		}
	}
	else		{
		length>>=osl_audioVoices[i].divider;
		if (osl_audioVoices[i].mono == 0)		{
			//Stro
			for (j=0;j<length;j++)			{
				cur1 = get_next_wav_sample(wav);
				cur2 = get_next_wav_sample(wav);
				for (k=0;k<samples;k++)			{
					*data++ = cur1;
					*data++ = cur2;
				}
			}
		}
		else		{
			//Mono
			for (j=0;j<length;j++)			{
				cur1 = get_next_wav_sample(wav);
				for (k=0;k<samples;k++)
					*data++ = cur1;
			}
		}
	}
	//Termin, les poteaux
	if (wav->chunk_left <= 0)			{
		if (osl_audioVoices[i].sound->endCallback)		{
			if (osl_audioVoices[i].sound->endCallback(osl_audioVoices[i].sound, i))
				return;
		}
		oslAudioDeleteChannel(i);
	}
}

/* Fonction utilise pour remplir le buffer audio (44'100 Hz, 16 bits, Mono) */
void oslAudioCallback(unsigned int i, void* buf, unsigned int length) {
//	sample_t* ubuf = (sample_t*) buf;
	void *buf2;
	unsigned int l=0;
	OSL_ADGlobals *ad = (OSL_ADGlobals*)osl_audioVoices[i].dataplus;

	if (osl_audioVoices[i].format == OSL_FMT_WAV)			{
		oslDecodeWav(i, buf, length);
	}
	else		{
		memset(buf, 0, length<<2);
		if (osl_audioVoices[i].size <= 0)
			return;
		if (osl_audioVoices[i].format == OSL_FMT_ADPCM)			{
			l = length>>(osl_audioVoices[i].divider+1);
			if (l > osl_audioVoices[i].size)
				l = osl_audioVoices[i].size;
			buf2 = oslDecodeADMono(ad, (short*)buf, ad->data, l<<1, 1<<(osl_audioVoices[i].divider), osl_audioVoices[i].isStreamed);
			osl_audioVoices[i].size-=l;
		}
		if (osl_audioVoices[i].size <= 0 && l)			{
			memset(buf2, 0, (u32)buf+(length<<1)-(u32)buf2);
			if (osl_audioVoices[i].sound->endCallback)		{
				if (osl_audioVoices[i].sound->endCallback(osl_audioVoices[i].sound, i))
					return;
			}
			oslAudioDeleteChannel(i);
		}
	}
}

int osl_audioStandBy;
#ifdef PSP
int oslAudioPowerCallback(int unknown, int pwrflags,void *common)			{
	static signed char audio[OSL_NUM_AUDIO_CHANNELS];
	OSL_SOUND *s;
	SceUID f=0;
	int i;
	
	if ((pwrflags & PSP_POWER_CB_POWER_SWITCH))		{
		osl_audioStandBy = 1;
		for (i=0;i<OSL_NUM_AUDIO_CHANNELS;i++)			{
			s = osl_audioVoices[i].sound;
			if (s)			{
				if (s->isStreamed)		{
					audio[i] = osl_audioActive[i];
					osl_audioActive[i] = 3;					//3 = suspendu/invalide
					if (s->format == OSL_FMT_ADPCM)
						f = (SceUID)s->data;
					else if (s->format == OSL_FMT_WAV)
						f = (SceUID)((WAVE_SRC*)s->dataplus)->fp;
					osl_filesave[i] = sceIoLseek32(f, 0, SEEK_CUR);
				}
			}
/*			s = osl_audioVoices[i].sound;
			if (s)			{
				if (s->isStreamed)		{
					if (s->format == OSL_FMT_ADPCM)
						f = (FILE*)s->data;
					else if (s->format == OSL_FMT_WAV)
						f = (FILE*)((WAVE_SRC*)s->dataplus)->fp;
					files[i] = ftell(f);
					fclose(f);
				}
			}*/
//			oslAudioDeleteChannel(i);
		}
		for (i=0;i<1000000;i--)
			i+=2;
//		fcloseall();
		suspendNumber++;
	}
	else if(pwrflags & PSP_POWER_CB_RESUME_COMPLETE)		{
//		osl_testvalue = sceIoOpen ("test.bgm", 0x0001, 0777);
/*		for (i=0;i<OSL_NUM_AUDIO_CHANNELS;i++)			{
			s = osl_audioVoices[i].sound;
			if (s)			{
				if (s->isStreamed)		{
					f = fopen("test.bgm", "rb");
//					fseek(f, files[i], SEEK_SET);
					if (s->format == OSL_FMT_ADPCM)
						s->data = (void*)f;
					else if (s->format == OSL_FMT_WAV)
						((WAVE_SRC*)s->dataplus)->fp = (void*)f;
				}
			}
		}*/
/*		for (i=0;i<1000000;i--)
			i+=2;*/
//		for (i=0;i<OSL_NUM_AUDIO_CHANNELS;i++)
//			osl_audioActive[i] = audio[i];
		osl_audioStandBy = 0;
	}
	
	return 0;
}
#endif

int oslInitAudio()			{
	int i;

	for (i=0;i<OSL_NUM_AUDIO_CHANNELS;i++)			{
		osl_audioActive[i]=0;
		osl_audioVoices[i].sound = NULL;
	}
	audio_ready=0;

	for (i=0; i<OSL_NUM_AUDIO_CHANNELS; i++) {
		AudioStatus[i].handle = -1;
		AudioStatus[i].threadhandle = -1;
		AudioStatus[i].volumeright = OSL_VOLUME_MAX;
		AudioStatus[i].volumeleft  = OSL_VOLUME_MAX;
		AudioStatus[i].callback = 0;
	}
	memset(osl_audioVoices, 0, sizeof(osl_audioVoices));
	suspendNumber = 0;				//Peut-tre ne pas le refaire  chaque fois...
#ifdef PSP
	osl_powerCallback = oslAudioPowerCallback;
#endif
	osl_audioStandBy = 0;
	return 0;
}

//Supprime le systme son, mais vous devriez supprimer tous vos sons avant!
void oslDeinitAudio()		{
	int i;
	//Stoppe toutes les voies actives
	for (i=0;i<OSL_NUM_AUDIO_CHANNELS;i++)
		oslAudioDeleteChannel(i);
	osl_powerCallback = NULL;
	audio_ready=0;
}

OSL_SOUND *oslLoadBgmSoundFile(int stream, const char *filename)		{
	SceUID f;
	int debut, fin;
	OSL_SOUND *s;
	OSL_ADGlobals *ad=NULL;
	BGM_FORMAT_HEADER bfh;

	s = (OSL_SOUND*)malloc(sizeof(OSL_SOUND));
	if (!s)
		return NULL;

	f = sceIoOpen(filename, PSP_O_RDONLY, 0777);
	if (f < 0)		{
		free(s);
		return NULL;
	}
	sceIoRead(f, &bfh, sizeof(bfh));
	//Vrifie l'en-tte
	if (strcmp(bfh.strVersion, "OSLBGM v01"))		{
		free(s);
		sceIoClose(f);
		return NULL;
	}
	if (bfh.format == 1)		{
		//Pour l'adpcm, dataplus contient la structure dfinissant les donnes
		ad = (OSL_ADGlobals*)malloc(sizeof(OSL_ADGlobals));
		if (!ad)		{
			free(s);
			sceIoClose(f);
			return NULL;
		}
		s->dataplus = ad;
	}
	debut = sceIoLseek32(f, 0, SEEK_CUR);
	s->baseoffset = debut;
	sceIoLseek32(f, 0, SEEK_END);
	fin = sceIoLseek32(f, 0, SEEK_CUR);
	if (fin-debut <= 0)			{
		free(s);
		if (ad)	free(ad);
		sceIoClose(f);
		return NULL;
	}
	sceIoLseek32(f, 0, SEEK_SET);
	s->isStreamed = stream;
	if (s->isStreamed)			{
		if (strlen(filename) >= sizeof(s->filename))
			oslFatalError("Sound file name too long!");
		strcpy(s->filename, filename);
		s->suspendNumber = suspendNumber;
		s->data = (void*)f;
	}
	else		{
		s->data = malloc(fin-debut);
		if (!s->data)		{
			free(s);
			if (ad)	free(ad);
			sceIoClose(f);
			return NULL;
		}
		sceIoRead(f, s->data, fin-debut);
		sceIoClose(f);
	}
	s->endCallback = NULL;
	s->format = bfh.format;
	if (bfh.sampleRate == 44100)
		s->divider = OSL_FMT_44K;
	else if (bfh.sampleRate == 22050)
		s->divider = OSL_FMT_22K;
	else if (bfh.sampleRate == 11025)
		s->divider = OSL_FMT_11K;
	s->size = fin-debut;
//	if (bfh.format & OSL_FMT_STEREO)
//		s->mono = 0;				//OSL_AUDIO_FORMAT_STEREO
//	else
		s->mono = 0x10;				//OSL_AUDIO_FORMAT_MONO
	s->volumeLeft = s->volumeRight = OSL_VOLUME_MAX;
	return s;
}

OSL_SOUND *oslLoadSoundFile(const char *filename, int stream)		{
	OSL_SOUND *s;
	WAVE_SRC *wav;

	//Fichier BGM
	if (!strcmp(filename + strlen(filename) - 4, ".bgm"))
		return oslLoadBgmSoundFile(stream, filename);
	s = (OSL_SOUND*)malloc(sizeof(OSL_SOUND));
	if (!s)
		return NULL;

	//Structure wav
	wav = (WAVE_SRC*)malloc(sizeof(WAVE_SRC));
	if(!wav)
	{
		free(s);
		return NULL;
	}

	//Ouvre le fichier wav
	if (open_wave_src(wav, filename) < 0)				{
		free(s);
		free(wav);
		return NULL;
	}
	if (wav->fmt.channels == 1)
		s->mono = 0x10;					//OSL_AUDIO_FORMAT_MONO
	else
		s->mono = 0x00;					//OSL_AUDIO_FORMAT_STEREO
	wav->basefp = sceIoLseek32(wav->fp,0,SEEK_CUR);
	wav->chunk_base = wav->chunk_left;
	s->size = wav->chunk_left;
	s->endCallback = NULL;
	s->volumeLeft = s->volumeRight = OSL_VOLUME_MAX;
	s->format = OSL_FMT_WAV;
	if (wav->fmt.sample_rate >= 44100)
		s->divider = OSL_FMT_44K;
	else if (wav->fmt.sample_rate >= 22050)
		s->divider = OSL_FMT_22K;
	else
		s->divider = OSL_FMT_11K;
	s->isStreamed = stream;
	s->dataplus = wav;
	wav->stream = s->isStreamed;
	if (s->isStreamed)			{
		if (strlen(filename) >= sizeof(s->filename))
			oslFatalError("Sound file name too long!");
		s->suspendNumber = suspendNumber;
		strcpy(s->filename, filename);
	}
	else		{
		wav->database = (unsigned char*)malloc(s->size);
		if (!wav->database)		{
			free(s);
			close_wave_src(wav);
			free(wav);
			return NULL;
		}
		sceIoRead(wav->fp, wav->database, s->size);
		wav->data = wav->database;
		close_wave_src(wav);
	}
	return s;
}

void oslDeleteSound(OSL_SOUND *s)			{
	//Vrifie que le son n'est pas en train d'tre jou!
	oslStopSound(s);
	if (s->format == OSL_FMT_WAV)			{
		if (s->isStreamed)
			close_wave_src((WAVE_SRC*)s->dataplus);
		else
			free(((WAVE_SRC*)s->dataplus)->database);
		free(s->dataplus);
	}
	else if (s->format == OSL_FMT_ADPCM)		{
		if (s->isStreamed)		{
			sceIoClose((SceUID)s->data);
//			free(s->data);
		}
		else
			free(s->data);
	}
	free(s);
}

//Retour: 0=pas ractiv, 1=ractiv, 2=ractiv, mais il faut recommencer le son depuis le dbut
int oslAudioReactiveSound(OSL_SOUND *s)		{
	//Le son est en streaming et la PSP a t mise en veille -> on ne peut pas jouer le son directement puisque le kernel ferme tous les fichiers.
	if (s->isStreamed && s->suspendNumber < suspendNumber)		{
		SceUID f, *w=NULL;
		int i;
		//On rouvre le fichier
		f = sceIoOpen(s->filename, PSP_O_RDONLY, 0777);
		if (f < 0)
			return 0;
		if (s->format == OSL_FMT_ADPCM)			{
			w = (SceUID*)&s->data;
			oslRepriseAD((OSL_ADGlobals*)s->dataplus, (unsigned char*)f);
		}
		else if (s->format == OSL_FMT_WAV)
			w = (SceUID*)&((WAVE_SRC*)s->dataplus)->fp;
		i = oslGetSoundChannel(s);
		if (i >= 0)
			sceIoLseek32(f, osl_filesave[i], SEEK_SET);
		*w = f;
		s->suspendNumber = suspendNumber;
		if (i >= 0)
			return 1;
		else
			return 2;
	}
	return 0;
}

int oslSoundLoopFunc(OSL_SOUND *s, int voice)		{
	oslPlaySound(s, voice);
	return 1;
}

//A appeler en boucle lorsqu'on a du streaming et que la PSP peut passer en veille
void oslAudioVSync()		{
	int i;
	if (osl_audioStandBy)
		return;
	for (i=0;i<OSL_NUM_AUDIO_CHANNELS;i++)		{
		if (osl_audioActive[i]!=3)
			continue;
		if (osl_audioVoices[i].sound)		{
			if (oslAudioReactiveSound(osl_audioVoices[i].sound))
				osl_audioActive[i]=1;
		}
	}
}

void oslPlaySound(OSL_SOUND *s, int voice)			{
	//A VERIFIER: SI ELLE EST OCCUPEE, ON ATTEND UN PEU
	while(osl_audioActive[voice]==-2);
	//Cre la channel si elle n'existe pas dj
	if (!osl_audioActive[voice])
		oslAudioCreateChannel(voice, s->mono);
	else
		oslAudioRecreateChannel(voice, s->mono);

	osl_audioVoices[voice].data = s->data;
	osl_audioVoices[voice].format = s->format;
	osl_audioVoices[voice].size = s->size;
	osl_audioVoices[voice].divider = s->divider;
	osl_audioVoices[voice].mono = s->mono;
	osl_audioVoices[voice].dataplus = s->dataplus;
	osl_audioVoices[voice].isStreamed = s->isStreamed;
	osl_audioVoices[voice].volumeLeft = s->volumeLeft;
	osl_audioVoices[voice].volumeRight = s->volumeRight;
	//Essaie de ractiver le son (aprs une mise en veille), sinon recommence  zro
	if (oslAudioReactiveSound(s) != 1)		{
		if (s->format == OSL_FMT_ADPCM)		{
			if (s->isStreamed)
				sceIoLseek32((SceUID)s->data, s->baseoffset, SEEK_SET);
			oslStartAD((OSL_ADGlobals*)s->dataplus, (unsigned char*)s->data);
		}
		else if (s->format == OSL_FMT_WAV)			{
			if (s->isStreamed)
				sceIoLseek32(((WAVE_SRC*)s->dataplus)->fp, ((WAVE_SRC*)s->dataplus)->basefp, SEEK_SET);
			else
				((WAVE_SRC*)s->dataplus)->data = ((WAVE_SRC*)s->dataplus)->database;
			((WAVE_SRC*)s->dataplus)->chunk_left = ((WAVE_SRC*)s->dataplus)->chunk_base;
		}
	}
	oslAudioSetChannelCallback(voice, oslAudioCallback);
	//Les deux sont lis
	osl_audioVoices[voice].sound = s;
}

void oslStopSound(OSL_SOUND *s)			{
	int voice = oslGetSoundChannel(s);
	//Vrifie qu'il est bien en train d'tre jou...
	if (voice >= 0)
		oslAudioDeleteChannel(voice);
}

void oslPauseSound(OSL_SOUND *s, int pause)			{
	int voice = oslGetSoundChannel(s);
	//Vrifie qu'il est bien en train d'tre jou...
	if (voice >= 0)		{
		if (pause == -1)
			osl_audioActive[voice] = 3 - osl_audioActive[voice];
		else
			osl_audioActive[voice] = pause?2:1;
	}
}


