#include "oslib.h"

void oslShowNeoflashLogo()		{
	OSL_IMAGE *logo;
	float zoom;
	int counter, filter = osl_bilinearFilterEnabled;

	logo = oslLoadImageFile("neoflash/neoflash-psp.png", OSL_IN_RAM, OSL_PF_5650);
	if (!logo)		{
		oslDebug("To display the neoflash logo, please put the neoflash-psp.png file into the neoflash folder of your game and make sure the case is");
		return;
	}
	zoom = 0.05;
	counter = 0;
	oslSetBilinearFilter(1);

	while(!osl_quit)		{
		oslStartDrawing();
		//Agrandit (plus rapide pour l'entre que la sortie)
		if (counter >= 120)
			zoom *= 1.1;
		else
			zoom *= 1.15;
		//On le voit compltement
		if (zoom > 1)		{
			//Pause
			if (counter < 120)
				zoom = 1;
			counter++;
			//Fin de l'animation
			if (counter >= 152)
				break;
		}
		logo->stretchX = logo->sizeX * zoom;
		logo->stretchY = logo->sizeY * zoom;
		logo->x = (480 - logo->stretchX) / 2;
		logo->y = (272 - logo->stretchY) / 2;
		oslDrawImageSimple(logo);
		//Fade out
		if (counter > 120)
			oslDrawFillRect(0, 0, 480, 272, RGBA(0, 0, 0, (counter - 120) * 8));
		oslEndDrawing();
		oslSyncFrame();
	}
	oslDeleteImage(logo);
	//Restaure l'tat prcdent
	oslSetBilinearFilter(filter);
}

