#include "oslib.h"
#ifndef PSP
	#include "../MyOGL/GL/glext.h"
	#include "../MyOGL/OpenGL.h"
#endif

/*
	GRAPHICS
*/

#ifdef PSP
//	unsigned int __attribute__((aligned(64))) osl_list[262144];
#else
//	unsigned int osl_list[262144];
#endif
unsigned int *osl_list = NULL;
unsigned char *osl_vMemPtr = (u8*)(0x04088000);
//unsigned short *g_vMemPtr = (void*)(0x00100000);
//unsigned long osl_temp_texture[8*8];
//int osl_gradientTextureSampling=16;
int osl_quit=0, osl_doubleBuffer=1;
int osl_alignBuffer=1;
int osl_colorKeyEnabled, osl_colorKeyValue;
OSL_IMAGE osl_defaultBufferImage, osl_secondaryBufferImage, *osl_curBuf;
int osl_bilinearFilterEnabled, osl_isDrawingStarted=0;
int osl_vblInterruptNumber=0;
int (*osl_powerCallback)(int, int, void*)=NULL;
int osl_currentAlphaEffect, osl_currentAlphaCoeff;
OSL_CONTROLLER *osl_keys;

const int osl_pixelWidth[] = {16, 16, 16, 32, 4, 8};

float osl_fsinus[361];
float osl_fcosinus[361];

const int osl_isinus[361]=	{
	   0,    4,    9,   13,   18,   22,   27,   31,   36,   40,
	  44,   49,   53,   58,   62,   66,   71,   75,   79,   83,
	  88,   92,   96,  100,  104,  108,  112,  116,  120,  124,
	 128,  132,  136,  139,  143,  147,  150,  154,  158,  161,
	 165,  168,  171,  175,  178,  181,  184,  187,  190,  193,
	 196,  199,  202,  204,  207,  210,  212,  215,  217,  219,
	 222,  224,  226,  228,  230,  232,  234,  236,  237,  239,
	 241,  242,  243,  245,  246,  247,  248,  249,  250,  251,
	 252,  253,  254,  254,  255,  255,  255,  256,  256,  256,
	 256,  256,  256,  256,  255,  255,  255,  254,  254,  253,
	 252,  251,  250,  249,  248,  247,  246,  245,  243,  242,
	 241,  239,  237,  236,  234,  232,  230,  228,  226,  224,
	 222,  219,  217,  215,  212,  210,  207,  204,  202,  199,
	 196,  193,  190,  187,  184,  181,  178,  175,  171,  168,
	 165,  161,  158,  154,  150,  147,  143,  139,  136,  132,
	 128,  124,  120,  116,  112,  108,  104,  100,   96,   92,
	  88,   83,   79,   75,   71,   66,   62,   58,   53,   49,
	  44,   40,   36,   31,   27,   22,   18,   13,    9,    4,
	   0,   -3,   -8,  -12,  -17,  -21,  -26,  -30,  -35,  -39,
	 -43,  -48,  -52,  -57,  -61,  -65,  -70,  -74,  -78,  -82,
	 -87,  -91,  -95,  -99, -103, -107, -111, -115, -119, -123,
	-127, -131, -135, -138, -142, -146, -149, -153, -157, -160,
	-164, -167, -170, -174, -177, -180, -183, -186, -189, -192,
	-195, -198, -201, -203, -206, -209, -211, -214, -216, -218,
	-221, -223, -225, -227, -229, -231, -233, -235, -236, -238,
	-240, -241, -242, -244, -245, -246, -247, -248, -249, -250,
	-251, -252, -253, -253, -254, -254, -254, -255, -255, -255,
	-255, -255, -255, -255, -254, -254, -254, -253, -253, -252,
	-251, -250, -249, -248, -247, -246, -245, -244, -242, -241,
	-240, -238, -236, -235, -233, -231, -229, -227, -225, -223,
	-221, -218, -216, -214, -211, -209, -206, -203, -201, -198,
	-195, -192, -189, -186, -183, -180, -177, -174, -170, -167,
	-164, -160, -157, -153, -149, -146, -142, -138, -135, -131,
	-127, -123, -119, -115, -111, -107, -103,  -99,  -95,  -91,
	 -87,  -82,  -78,  -74,  -70,  -65,  -61,  -57,  -52,  -48,
	 -43,  -39,  -35,  -30,  -26,  -21,  -17,  -12,   -8,   -3,
	 0	
};

const int osl_icosinus[361]=	{
	 256,  256,  256,  256,  255,  255,  255,  254,  254,  253,
	 252,  251,  250,  249,  248,  247,  246,  245,  243,  242,
	 241,  239,  237,  236,  234,  232,  230,  228,  226,  224,
	 222,  219,  217,  215,  212,  210,  207,  204,  202,  199,
	 196,  193,  190,  187,  184,  181,  178,  175,  171,  168,
	 165,  161,  158,  154,  150,  147,  143,  139,  136,  132,
	 128,  124,  120,  116,  112,  108,  104,  100,   96,   92,
	  88,   83,   79,   75,   71,   66,   62,   58,   53,   49,
	  44,   40,   36,   31,   27,   22,   18,   13,    9,    4,
	   0,   -3,   -8,  -12,  -17,  -21,  -26,  -30,  -35,  -39,
	 -43,  -48,  -52,  -57,  -61,  -65,  -70,  -74,  -78,  -82,
	 -87,  -91,  -95,  -99, -103, -107, -111, -115, -119, -123,
	-127, -131, -135, -138, -142, -146, -149, -153, -157, -160,
	-164, -167, -170, -174, -177, -180, -183, -186, -189, -192,
	-195, -198, -201, -203, -206, -209, -211, -214, -216, -218,
	-221, -223, -225, -227, -229, -231, -233, -235, -236, -238,
	-240, -241, -242, -244, -245, -246, -247, -248, -249, -250,
	-251, -252, -253, -253, -254, -254, -254, -255, -255, -255,
	-255, -255, -255, -255, -254, -254, -254, -253, -253, -252,
	-251, -250, -249, -248, -247, -246, -245, -244, -242, -241,
	-240, -238, -236, -235, -233, -231, -229, -227, -225, -223,
	-221, -218, -216, -214, -211, -209, -206, -203, -201, -198,
	-195, -192, -189, -186, -183, -180, -177, -174, -170, -167,
	-164, -160, -157, -153, -149, -146, -142, -138, -135, -131,
	-127, -123, -119, -115, -111, -107, -103,  -99,  -95,  -91,
	 -87,  -82,  -78,  -74,  -70,  -65,  -61,  -57,  -52,  -48,
	 -43,  -39,  -35,  -30,  -26,  -21,  -17,  -12,   -8,   -3,
	   0,    4,    9,   13,   18,   22,   27,   31,   36,   40,
	  44,   49,   53,   58,   62,   66,   71,   75,   79,   83,
	  88,   92,   96,  100,  104,  108,  112,  116,  120,  124,
	 128,  132,  136,  139,  143,  147,  150,  154,  158,  161,
	 165,  168,  171,  175,  178,  181,  184,  187,  190,  193,
	 196,  199,  202,  204,  207,  210,  212,  215,  217,  219,
	 222,  224,  226,  228,  230,  232,  234,  236,  237,  239,
	 241,  242,  243,  245,  246,  247,  248,  249,  250,  251,
	 252,  253,  254,  254,  255,  255,  255,  256,  256,  256,
	 256	
};

void oslSetupFTrigo()		{
	int i;
	for (i=0;i<361;i++)			{
//		osl_fsinus[i] = vfpu_sini(i,1);
//		osl_fcosinus[i] = vfpu_cosi(i,1);
		osl_fsinus[i] = sin(i * 3.1415926535898f / 180.f);
		osl_fcosinus[i] = cos(i * 3.1415926535898f / 180.f);
//		osl_fsinus[i] = osl_isinus[i]/256.0;
//		osl_fcosinus[i] = osl_icosinus[i]/256.0;
	}
}

float oslCos(int angle, int dist)		{
	angle = angle%360;
	if (angle<0)
		angle+=360;
	return osl_fcosinus[angle]*dist;
//	return vfpu_cos(vfpu_i2f(angle), vfpu_i2f(dist));
}

float oslSin(int angle, int dist)		{
//	return vfpu_sin(vfpu_i2f(angle), vfpu_i2f(dist));
	angle = angle%360;
	if (angle<0)
		angle+=360;
	return osl_fsinus[angle]*dist;
}

int oslGetNextPower2(int val)			{
	int i;
	for (i=15;i>=0;i--)			{
		if (val & (1<<i))		{
			if (val & ~(1<<i))			{
				val = (1<<(i+1));
			}
			else
				val = (1<<i);
			break;
		}
	}
	return val;
}

//Aligne les donnes aux align octets prs (align doit tre une puissance de deux)
unsigned int oslAlignData(unsigned int data, int align)
{
	if (data & (align-1))
		data = (data & ~(align-1)) + align;
	return data;
}

//L'image fera en ralit sysSizeX*sizeY*pixelDepth octets
OSL_IMAGE *oslCreateImage(int larg, int haut, short location, short pixelFormat)		{
	OSL_IMAGE *img;
	img = (OSL_IMAGE*)malloc(sizeof(OSL_IMAGE));
	if (!img)
		goto _error;
	memset(img, 0, sizeof(OSL_IMAGE));
	img->sizeX = larg;
	img->sizeY = haut;
	//Taille
	img->stretchX = larg;
	img->stretchY = haut;
	//Partie de texture
	img->offsetX0 = img->offsetY0 = 0;
	img->offsetX1 = larg, img->offsetY1 = haut;
/*	if (pixelFormat == OSL_PF_5650)
		img->alpha.fxType = OSL_FX_NONE;
	else
		img->alpha.fxType = OSL_FX_RGBA;
	img->alpha.fxCoeffSrc = 0xff;*/
	img->sysSizeX = oslGetNextPower2(img->sizeX);
	img->sysSizeY = oslGetNextPower2(img->sizeY);
	img->location = location;
	img->pixelFormat = pixelFormat;
	img->autoStrip = 1;
	img->isCopy = img->isSwizzled = 0;
	img->realSizeX = osl_alignBuffer?img->sysSizeX:img->sizeX;
	//[OPTIMISER] Apparemment, la largeur doit tre aligne au quad-word
	if (img->realSizeX % (128/osl_pixelWidth[pixelFormat]))			{
		img->realSizeX /= (128/osl_pixelWidth[pixelFormat]);
		img->realSizeX ++;
		img->realSizeX *= (128/osl_pixelWidth[pixelFormat]);
	}
#ifdef PSP
	img->realSizeY = img->sizeY;
#else
	img->realSizeY = img->sysSizeY;
#endif
	//Taille (en octets) -> pixelWidth est exprim en bits (multipli par 8)
	img->totalSize = (img->realSizeX*img->realSizeY*osl_pixelWidth[img->pixelFormat])>>3;
	img->palette = NULL;
#ifndef PSP
	location = OSL_IN_RAM;
#endif
	if (location == OSL_IN_VRAM)		{
		img->data = osl_vMemPtr;
		osl_vMemPtr += img->totalSize;
		if ((void*)osl_vMemPtr > (void*)0x04200000)
			goto _error;
	}
	else if (location == OSL_IN_RAM)			{
		img->data = memalign(16, img->totalSize);
		if (!img->data)
			goto _error;
	}
	return img;

_error:
	if (img)
		free(img);
	return NULL;
}

void oslDeleteImage(OSL_IMAGE *img)
{
	if (!img->isCopy)			{
		if (img->location == OSL_IN_RAM)
			free(img->data);
		else if (img->location == OSL_IN_VRAM)
			osl_vMemPtr -= img->totalSize;
		if (img->palette)		{
			free(img->palette->data);
			free(img->palette);
		}
	}
	free(img);
}

/*void oslUncacheImage(OSL_IMAGE *img)
{
	//Ncessaire avant de pouvoir dessiner ou manier l'image ( appeler aprs une modification du contenu de  img->data  la main)
	sceKernelDcacheWritebackInvalidateRange(img->data, img->totalSize);
}*/

//Copie les donnes d'une image vers l'autre pour autant que les deux ont des proprits identiques
void oslCopyImage(OSL_IMAGE *imgDst, OSL_IMAGE *imgSrc)
{
	if (imgSrc->pixelFormat != imgDst->pixelFormat || imgSrc->totalSize > imgDst->totalSize || imgSrc->realSizeX != imgDst->realSizeX)			{
		oslFatalError("oslCopyImage: Both images must have the same size and pixel format!");
		return;
	}
	else		{
		//Vide les caches -> pas ncessaire si on indique  l'utilisateur de le faire avant cette copie!
		oslUncacheImage(imgDst);
		oslUncacheImage(imgSrc);
		sceDmacMemcpy(imgDst->data, imgSrc->data, imgSrc->totalSize);
		oslUncacheImage(imgDst);
//		sceGuCopyImage(imgSrc->pixelFormat,0,0,imgSrc->sizeX,imgSrc->sizeY,imgSrc->realSizeX,imgSrc->data,0,0,imgDst->realSizeX,imgDst->data);
	}
}

void oslSwizzleImage(OSL_IMAGE *imgDst, OSL_IMAGE *imgSrc)
{
	if (imgSrc->pixelFormat != imgDst->pixelFormat || imgSrc->totalSize != imgDst->totalSize)			{
		oslFatalError("oslCopyImage: Both images must have the same size and pixel format!");
		return;
	}
	else		{
		oslSwizzleTexture((u8*)imgDst->data, (u8*)imgSrc->data, (imgSrc->realSizeX*osl_pixelWidth[imgSrc->pixelFormat])>>3, imgSrc->sizeY);
		oslUncacheImage(imgDst);
		imgDst->isSwizzled = 1;
	}
}

//UTILISE UNIQUEMENT ICI, TROUVER UNE SOLUTION AVEC DMA HARDWARE, C'EST VRAIMENT PLUS RAPIDE!!!
void oslFasterMemset(u64 *dst, u64 *src, u32 length)			{
	u32 len = length>>6;
	u8 *dst2, *src2;
	while (len--)		{
		*dst++ = *src;
		*dst++ = *src;
		*dst++ = *src;
		*dst++ = *src;
		*dst++ = *src;
		*dst++ = *src;
		*dst++ = *src;
		*dst++ = *src;
	}
	len = (length & 63) >> 3;
	while (len--)
		*dst++ = *src;
	dst2 = (u8*)dst;
	src2 = (u8*)src;
	len = (length & 7);
	while (len--)
		*dst2++ = *src2++;
}

void oslClearImage(OSL_IMAGE *img, int color)
{
/*	if (img->location == OSL_IN_VRAM)		{
		OSL_IMAGE *db = oslGetDrawBuffer();
		int curAl = osl_currentAlphaEffect, curCo = osl_currentAlphaCoeff;
		oslSetAlpha(OSL_FX_NONE, 0);
		oslSetDrawBuffer(img);
		sceGuClearColor(color);
		sceGuClear(GU_COLOR_BUFFER_BIT);
		oslSetAlpha(curAl, curCo);
		oslSetDrawBuffer(db);
	}
	else		{*/
		u32 c64[2];
		//A TESTER!!!!
		if (img->pixelFormat == OSL_PF_5650)		{
			color = (((color&0xff0000)>>19)<<11) | (((color&0xff00)>>10)<<5) | ((color&0xff)>>3);
			color = color | (color<<16);
		}
		else if (img->pixelFormat == OSL_PF_5551)		{
			color = (((color&0xff000000)>>31)<<15) | (((color&0xff0000)>>19)<<10) | (((color&0xff00)>>11)<<5) | ((color&0xff)>>3);
			color = color | (color<<16);
		}
		else if (img->pixelFormat == OSL_PF_4444)			{
			color = (((color&0xff000000)>>28)<<12) | (((color&0xff0000)>>20)<<8) | (((color&0xff00)>>12)<<4) | ((color&0xff)>>4);
			color = color | (color<<16);
		}
		else if (img->pixelFormat == OSL_PF_8BIT)
			color = color | (color<<8) | (color<<16) | (color<<24);
		else if (img->pixelFormat == OSL_PF_4BIT)
			color = color | (color<<4) | (color<<8) | (color<<12) | (color<<16) | (color<<20) | (color<<24) | (color<<28);
		c64[0] = color;
		c64[1] = color;
		oslFasterMemset((u64*)img->data, (u64*)c64, img->totalSize);
		oslUncacheImage(img);
//	}
}

OSL_IMAGE *oslCreateImageCopy(OSL_IMAGE *src, int newLocation)
{
	OSL_IMAGE *img;
	if (!src)
		return NULL;
	img = oslCreateImage(src->sizeX, src->sizeY, newLocation, src->pixelFormat);
	if (img)
		oslCopyImage(img, src);
	return img;
}

OSL_IMAGE *oslCreateSwizzledImage(OSL_IMAGE *src, int newLocation)
{
	OSL_IMAGE *img;
	if (!src)
		return NULL;
	img = oslCreateImage(src->sizeX, src->sizeY, newLocation, src->pixelFormat);
	if (img)
		oslSwizzleImage(img, src);
	return img;
}

void oslSetAlpha(int effect, int coeff)		{
	int effet;
	osl_currentAlphaEffect = effect;
	osl_currentAlphaCoeff = coeff;
	if (effect > OSL_FX_NONE)		{
/*		if (effect & OSL_FX_RGB)		{
			coeff = c1;
			coeff2 = c2;
		}
		else		{
			coeff = c1 & 0xff;
			coeff |= (coeff<<8) | (coeff<<16) | (coeff<<24);
			coeff2 = c2 & 0xff;
			coeff2 |= (coeff2<<8) | (coeff2<<16) | (coeff<<24);
		}*/
		effet = effect & ~OSL_FX_COLOR;
		if (effet == OSL_FX_RGBA)		{			//fxCoeff=0 -> transparent, fxCoeff=255 -> opaque
			sceGuBlendFunc(GU_ADD,GU_SRC_ALPHA,GU_ONE_MINUS_SRC_ALPHA,0,0);
			sceGuTexFunc(GU_TFX_REPLACE, GU_TCC_RGBA);
			sceGuAmbientColor(0xffffffff);
//			sceGuTexEnvColor(0xffffffff);
		}
		else if (effet == OSL_FX_ALPHA)		{		//fxCoeff=0 -> transparent, fxCoeff=255 -> opaque
			sceGuBlendFunc(GU_ADD,GU_SRC_ALPHA,GU_ONE_MINUS_SRC_ALPHA,0,0);
			sceGuTexFunc(GU_TFX_MODULATE, GU_TCC_RGBA);
			if (effect & OSL_FX_COLOR)
				sceGuAmbientColor(coeff);
			else
				sceGuAmbientColor((coeff<<24)|0xffffff);
		}
		else if (effet == OSL_FX_ADD)	{				//fxCoeff: opacit de l'objet, fxCoeffSrc: modifie la source
			sceGuBlendFunc(GU_ADD,GU_SRC_ALPHA,GU_FIX,0,0xffffffff);
			sceGuTexFunc(GU_TFX_MODULATE, GU_TCC_RGBA);
			if (effect & OSL_FX_COLOR)
				sceGuAmbientColor(coeff);
			else
				sceGuAmbientColor((coeff<<24)|0xffffff);
		}
		else if (effet == OSL_FX_SUB)		{			//fxCoeff: opacit de l'objet, fxCoeffSrc: modifie la source
			sceGuBlendFunc(GU_REVERSE_SUBTRACT,GU_SRC_ALPHA,GU_FIX,0,0xffffffff);
			sceGuTexFunc(GU_TFX_MODULATE, GU_TCC_RGBA);
			if (effect & OSL_FX_COLOR)
				sceGuAmbientColor(coeff);
			else
				sceGuAmbientColor((coeff<<24)|0xffffff);
		}
/*		else if (effet == OSL_FX_TINT)			{
			sceGuBlendFunc(GU_ADD,GU_SRC_ALPHA,GU_ONE_MINUS_SRC_ALPHA,0,0);
			sceGuTexFunc(GU_TFX_MODULATE, GU_TCC_RGBA);
			if (effect & OSL_FX_COLOR)
				sceGuAmbientColor(coeff);
		}*/
/*		if (effet == OSL_FX_FLAT)		{
			sceGuAlphaFunc(GU_GREATER, 0, 0xff);
			sceGuEnable(GU_ALPHA_TEST);
			sceGuTexFunc(GU_TFX_REPLACE, GU_TCC_RGBA);
			sceGuAmbientColor(0xffffffff);
			sceGuDisable(GU_BLEND);
		}
		else		{
			sceGuDisable(GU_ALPHA_TEST);
			sceGuEnable(GU_BLEND);
		}*/
		sceGuEnable(GU_BLEND);
	}
	else
		sceGuDisable(GU_BLEND);
}

void oslDisableTransparentColor()		{
	osl_colorKeyEnabled = 0;
	sceGuDisable(GU_COLOR_TEST);
}

void oslSetTransparentColor(OSL_COLOR color)			{
	osl_colorKeyEnabled = 1;
	osl_colorKeyValue = color;
//	sceGuColorFunc(GU_NOTEQUAL,0,0xffffffff);
	sceGuColorFunc(GU_NOTEQUAL, color, 0xffffffff);
	sceGuEnable(GU_COLOR_TEST);
}


//Vrifie s'il y a besoin de faire un strip blit et le fait. Retourne 1 si le blit a t fait, 0 s'il faut blitter normalement.
//Attention: ne supporte pas la rotation ou les dformations avances!
//ATTENTION: UTILISER LA VFPU!
int oslVerifyStripBlit(OSL_IMAGE *img)		{
	int i, ud, uf, size;
	float xd, xf, zoomX;
	//Ne tient pas dans une page
	size = (int)img->offsetX1 - (int)img->offsetX0;
	if (size > OSL_SLICE_SIZE && img->angle==0 && img->centerX==0 && img->centerY==0)			{
		OSL_PRECISE_VERTEX *vertices;

		zoomX = (float)img->stretchX/size;
		for (i=0;i<size;i+=OSL_SLICE_SIZE)			{
			vertices = (OSL_PRECISE_VERTEX*)sceGuGetMemory(4 * sizeof(OSL_PRECISE_VERTEX));
			ud = i;
			if ((i + OSL_SLICE_SIZE) > size)
				uf = size;
			else
				uf = i + OSL_SLICE_SIZE;
			xd = img->x + i * zoomX;
			xf = img->x + uf * zoomX;

			vertices[0].u = img->offsetX0 + ud;
			vertices[0].v = img->offsetY0;
			vertices[0].x = xd;
			vertices[0].y = img->y;
			vertices[0].z = 0;

			vertices[1].u = img->offsetX0 + uf;
			vertices[1].v = img->offsetY0;
			vertices[1].x = xf;
			vertices[1].y = img->y;
			vertices[1].z = 0;

			vertices[2].u = img->offsetX0 + ud;
			vertices[2].v = img->offsetY1;
			vertices[2].x = xd;
			vertices[2].y = img->y + img->stretchY;
			vertices[2].z = 0;

			vertices[3].u = img->offsetX0 + uf;
			vertices[3].v = img->offsetY1;
			vertices[3].x = xf;
			vertices[3].y = img->y + img->stretchY;
			vertices[3].z = 0;

			sceGuDrawArray(GU_TRIANGLE_STRIP,GU_TEXTURE_32BITF|GU_VERTEX_32BITF|GU_TRANSFORM_2D,4,0,vertices);
		}
		return 1;
	}
	else
		return 0;
}

void *osl_curTexture=NULL, *osl_curPalette=NULL;

void oslUncachePalette(OSL_PALETTE *pal)
{
	sceKernelDcacheWritebackInvalidateRange(pal->data, (pal->nElements * osl_pixelWidth[pal->pixelFormat]) >> 3);
	//A ruploader la prochaine fois :)
	if (pal == osl_curPalette)
		osl_curPalette = NULL;
}


inline void oslSetTexture(OSL_IMAGE *img)		{
	if (img->palette && osl_curPalette != img->palette)		{
		osl_curPalette = img->palette;
		//Change la palette
		sceGuClutMode(img->palette->pixelFormat,0,0xff,0);
		//Uploade la palette
		sceGuClutLoad((img->palette->nElements>>3), img->palette->data);
	}
	if (osl_curTexture != img->data)		{
		osl_curTexture = img->data;
		//Change la texture
		sceGuTexMode(img->pixelFormat,0,0,img->isSwizzled);
//		sceGuTexFunc(GU_TFX_REPLACE, img->pixelFormat==OSL_PF_5650?GU_TCC_RGB:GU_TCC_RGBA);
		sceGuTexImage(0, img->sysSizeX, img->sysSizeY, img->sysSizeX, img->data);
	}
}

/*
	Marche pas, le pixelformat doit tre le mme que le buffer
inline void DrawImageFast(IMAGE *img)
{
	sceGuCopyImage(GU_PSM_4444,0,0,img->sizeX,img->sizeY,img->sizeX,img->data,img->x,img->y,512,(void*)(0x04000000+(u32)g_curDrawBuf));
}*/


//4.72 ms sans support zoom (comment) et 4.91 ms avec
void oslDrawImageSimple(OSL_IMAGE *img)				{
		OSL_UVFLOAT_VERTEX *vertices;

		// do a striped blit (takes the page-cache into account)
		oslSetTexture(img);
		if (img->autoStrip)		{
			if (oslVerifyStripBlit(img))
				return;
		}

		vertices = (OSL_UVFLOAT_VERTEX*)sceGuGetMemory(2 * sizeof(OSL_UVFLOAT_VERTEX));

		vertices[0].u = img->offsetX0;
		vertices[0].v = img->offsetY0;
		vertices[0].x = img->x;
		vertices[0].y = img->y;
		vertices[0].z = 0;

		vertices[1].u = img->offsetX1;
		vertices[1].v = img->offsetY1;
		vertices[1].x = img->x + img->stretchX;
		vertices[1].y = img->y + img->stretchY;
		vertices[1].z = 0;

		sceGuDrawArray(GU_SPRITES,GU_TEXTURE_32BITF|GU_VERTEX_16BIT|GU_TRANSFORM_2D,2,0,vertices);
}

/*float calc_x(int angle, int cX, int cY, int x)
{
	//cos(angle, cX) - sin(angle, cY) + x
	float vfpu_vars[8];
	register void *ptr __asm ("a0") = vfpu_vars; 
	*(int*)ptr = angle;
	*((int*)ptr+1) = cX;
	*((int*)ptr+2) = cY;
	*((int*)ptr+3) = x;
	vfpu_vars[4] = 90;
	__asm__ volatile ( 
		//Chargement des registres
		cgen_asm(lv_s(0, 0, R_a0, 0))			//r0 = angle
		cgen_asm(lv_s(1, 1, R_a0, 0))			//r1 = cX
		cgen_asm(lv_s(2, 2, R_a0, 0))			//r2 = cY
		cgen_asm(lv_s(3, 3, R_a0, 0))			//r3 = x
		cgen_asm(lv_s(4, 4, R_a0, 0))			//r4 = 90
		//Convertit les entiers (r0  r3) en float
		cgen_asm(vi2f_s(0, 0, 0))
		cgen_asm(vi2f_s(1, 1, 0))
		cgen_asm(vi2f_s(2, 2, 0))
		cgen_asm(vi2f_s(3, 3, 0))
		//Divise l'angle par 90
		cgen_asm(vdiv_s(0, 0, 4))				//r0 = r0 / 90
		//r5 = cos(angle) * cX
		cgen_asm(vcos_s(5, 0))					//r5 = cos(r0)
		cgen_asm(vmul_s(5, 5, 1))				//r5 = r5 * r1
		//r6 = sin(angle)* cY
		cgen_asm(vsin_s(6, 0))					//r6 = sin(r0)
		cgen_asm(vmul_s(6, 6, 1))				//r6 = r6 * r1
		//Additionne le tout dans r124
		cgen_asm(vadd_s(124, 5, 6))				//r124 = r5 + r6
		cgen_asm(vadd_s(124, 124, 3))			//r124 = r124 + r3
		cgen_asm(sv_q(31, 0 * 4, R_a0, 0)) 
	: "=r"(ptr) : "r"(ptr) : "memory"); 
	return vfpu_vars[0];
}*/

void oslDrawImage(OSL_IMAGE *img)				{
		OSL_PRECISE_VERTEX *vertices;
//		int rsX, rsY;
		int cX, cY, tmpX, tmpY;

		oslSetTexture(img);
		//Attention, la rotation sera dsactive
		if (img->autoStrip)		{
			if (oslVerifyStripBlit(img))
				return;
		}

		vertices = (OSL_PRECISE_VERTEX*)sceGuGetMemory(4 * sizeof(OSL_PRECISE_VERTEX));

		cX = (-img->centerX*img->stretchX)/(int)(img->offsetX1 - img->offsetX0);
		cY = (-img->centerY*img->stretchY)/(int)(img->offsetY1 - img->offsetY0);

		tmpX = cX + img->stretchX;
		tmpY = cY + img->stretchY;

		vertices[0].u = img->offsetX0;
		vertices[0].v = img->offsetY0;
		vertices[0].x = oslCos(img->angle, cX) - oslSin(img->angle, cY) + img->x;
		vertices[0].y = oslSin(img->angle, cX) + oslCos(img->angle, cY) + img->y;
		vertices[0].z = 0;

		vertices[1].u = img->offsetX1;
		vertices[1].v = img->offsetY0;
		vertices[1].x = oslCos(img->angle, tmpX) - oslSin(img->angle, cY) + img->x;
		vertices[1].y = oslSin(img->angle, tmpX) + oslCos(img->angle, cY) + img->y;
		vertices[1].z = 0;

		vertices[2].u = img->offsetX0;
		vertices[2].v = img->offsetY1;
		vertices[2].x = oslCos(img->angle, cX) - oslSin(img->angle, tmpY) + img->x;
		vertices[2].y = oslSin(img->angle, cX) + oslCos(img->angle, tmpY) + img->y;
		vertices[2].z = 0;

		vertices[3].u = img->offsetX1;
		vertices[3].v = img->offsetY1;
		vertices[3].x = oslCos(img->angle, tmpX) - oslSin(img->angle, tmpY) + img->x;
		vertices[3].y = oslSin(img->angle, tmpX) + oslCos(img->angle, tmpY) + img->y;
		vertices[3].z = 0;

		sceGuDrawArray(GU_TRIANGLE_STRIP,GU_TEXTURE_32BITF|GU_VERTEX_32BITF|GU_TRANSFORM_2D,4,0,vertices);
}

//Optionnel: image dcrivant les effets (alpha, ...)
//Sinon laisse le dernier effet utilis
void oslDrawLine(int x0, int y0, int x1, int y1, OSL_COLOR color)		{
		OSL_LINE_VERTEX* vertices;

		vertices = (OSL_LINE_VERTEX*)sceGuGetMemory(2 * sizeof(OSL_LINE_VERTEX));

		vertices[0].color = color;
		vertices[0].x = x0;
		vertices[0].y = y0;
		vertices[0].z = 0;

		vertices[1].color = color;
		vertices[1].x = x1;
		vertices[1].y = y1;
		vertices[1].z = 0;

		sceGuDisable(GU_TEXTURE_2D);
		sceGuDrawArray(GU_LINES, GU_COLOR_8888|GU_VERTEX_16BIT|GU_TRANSFORM_2D, 2, 0, vertices);
		sceGuEnable(GU_TEXTURE_2D);
}

void oslDrawRect(int x0, int y0, int x1, int y1, OSL_COLOR color)		{
		OSL_LINE_VERTEX* vertices;
		int i;

		vertices = (OSL_LINE_VERTEX*)sceGuGetMemory(8 * sizeof(OSL_LINE_VERTEX));

		//Swap si ncessaire
		if (x1<x0)		{
			i=x0;
			x0=x1;
			x1=i;
		}
		if (y1<y0)		{
			i=y0;
			y0=y1;
			y1=i;
		}

		vertices[0].color = color;
		vertices[0].x = x0;
		vertices[0].y = y0+1;
		vertices[0].z = 0;

		vertices[1].color = color;
		vertices[1].x = x0;
		vertices[1].y = y1;
		vertices[1].z = 0;

		vertices[2].color = color;
		vertices[2].x = x0+1;
		vertices[2].y = y1-1;
		vertices[2].z = 0;

		vertices[3].color = color;
		vertices[3].x = x1;
		vertices[3].y = y1-1;
		vertices[3].z = 0;

		vertices[4].color = color;
		vertices[4].x = x1-1;
		vertices[4].y = y0;
		vertices[4].z = 0;

		vertices[5].color = color;
		vertices[5].x = x1-1;
		vertices[5].y = y1-1;
		vertices[5].z = 0;

		vertices[6].color = color;
		vertices[6].x = x0;
		vertices[6].y = y0;
		vertices[6].z = 0;

		vertices[7].color = color;
		vertices[7].x = x1-1;
		vertices[7].y = y0;
		vertices[7].z = 0;

		sceGuDisable(GU_TEXTURE_2D);
		sceGuDrawArray(GU_LINES, GU_COLOR_8888|GU_VERTEX_16BIT|GU_TRANSFORM_2D, 8, 0, vertices);
		sceGuEnable(GU_TEXTURE_2D);
}

void oslDrawFillRect(int x0, int y0, int x1, int y1, OSL_COLOR color)		{
		OSL_LINE_VERTEX* vertices;

		vertices = (OSL_LINE_VERTEX*)sceGuGetMemory(4 * sizeof(OSL_LINE_VERTEX));

		vertices[0].color = color;
		vertices[0].x = x0;
		vertices[0].y = y0;
		vertices[0].z = 0;

		vertices[1].color = color;
		vertices[1].x = x1;
		vertices[1].y = y0;
		vertices[1].z = 0;

		vertices[2].color = color;
		vertices[2].x = x0;
		vertices[2].y = y1;
		vertices[2].z = 0;

		vertices[3].color = color;
		vertices[3].x = x1;
		vertices[3].y = y1;
		vertices[3].z = 0;

		sceGuDisable(GU_TEXTURE_2D);
		sceGuDrawArray(GU_TRIANGLE_STRIP, GU_COLOR_8888|GU_VERTEX_16BIT|GU_TRANSFORM_2D, 4, 0, vertices);
		sceGuEnable(GU_TEXTURE_2D);
}


void oslStartDrawing()		{
	//Dessin dj commenc?
	if (osl_isDrawingStarted)
		return;
	osl_isDrawingStarted = 1;
	osl_curTexture = NULL;
	osl_curPalette=NULL;
	sceGuStart(GU_DIRECT, osl_list);
//	sceGuTexMode(GU_PSM_8888,0,0,0);
	oslSetAlpha(OSL_FX_RGBA, 0);
/*	sceGuBlendFunc(GU_ADD,GU_SRC_ALPHA,GU_ONE_MINUS_SRC_ALPHA,0,0);
	sceGuTexFunc(GU_TFX_REPLACE, GU_TCC_RGBA);
	sceGuEnable(GU_BLEND);*/
//	sceGuAlphaFunc(GU_LESS, 0xff, 0xff);
//	sceGuAlphaFunc(GU_GREATER, 0, 0xff);
//	sceGuEnable(GU_ALPHA_TEST);
//	sceGuTexScale(1.0f/512.0f,1.0f/512.0f);		// scale UVs to 0..1
//	sceGuTexScale(1,1);
//	sceGuTexOffset(0.0f, 0.0f);
//	sceGuTexFilter(GU_LINEAR,GU_LINEAR);
//	sceGuTexWrap(GU_CLAMP, GU_CLAMP);
	//Moins que 32 bits? -> active le dithering
	if (osl_currentResolutionBPP < 32)
		sceGuEnable(GU_DITHER);
	else
		sceGuDisable(GU_DITHER);
}

void oslEndDrawing()		{
	if (!osl_isDrawingStarted)
		return;
	sceGuFinish();
	sceGuSync(0,0);
	osl_isDrawingStarted = 0;
}

void oslSyncDrawing()			{
	if (osl_isDrawingStarted)		{
		sceGuFinish();
		sceGuSync(0,0);
		sceGuStart(GU_DIRECT,osl_list);
	}
}

int osl_currentResolutionBPP=32, osl_currentPixelFormat=GU_PSM_8888;

void oslInitGfx(int pixelFormat, int bDoubleBuffer)			{
	osl_doubleBuffer = bDoubleBuffer;
	osl_currentPixelFormat = pixelFormat;
	osl_currentResolutionBPP = osl_pixelWidth[pixelFormat];

	pspDebugScreenInit();
	oslSetupFTrigo();

	sceGuInit();
	if (!osl_list)
		osl_list = (unsigned int*)memalign(64, 1<<20);

	// setup
	sceGuStart(GU_DIRECT,osl_list);
	sceGuDrawBuffer(osl_currentPixelFormat,(void*)0,512);
	if (bDoubleBuffer)			{
		sceGuDispBuffer(480,272,(void*)((0x22000*osl_currentResolutionBPP)>>3),512);
		osl_vMemPtr = (u8*)(OSL_UVRAM_BASE + ((0x22000*2*osl_currentResolutionBPP)>>3));
		//Displaybuffer et drawbuffer initiaux
		osl_curDrawBuf = (void*)OSL_UVRAM_BASE;
		osl_curDispBuf = (void*)(OSL_UVRAM_BASE + ((0x22000*osl_currentResolutionBPP)>>3));
	}
	else			{
		sceGuDispBuffer(480,272,(void*)0,512);
		osl_vMemPtr = (u8*)(OSL_UVRAM_BASE + ((0x22000*osl_currentResolutionBPP)>>3));
		//Displaybuffer et drawbuffer initiaux
		osl_curDrawBuf = (void*)OSL_UVRAM_BASE;
		osl_curDispBuf = osl_curDrawBuf;
	}

//	sceGuDepthBuffer((void*)0x110000,512);
//	sceGuOffset(2048 - (480/2),2048 - (272/2));
//	sceGuViewport(2048,2048,480,272);
//	sceGuDepthRange(0xc350,0x2710);
	sceGuScissor(0,0,480,272);
	sceGuEnable(GU_SCISSOR_TEST);
//	sceGuFrontFace(GU_CW);
	sceGuEnable(GU_TEXTURE_2D);
//	sceGuClear(GU_COLOR_BUFFER_BIT);
	sceGuTexFilter(GU_NEAREST,GU_NEAREST);
	sceGuShadeModel(GU_SMOOTH);
	osl_bilinearFilterEnabled = 0;
	osl_isDrawingStarted = 0;

	sceGuFinish();
	sceGuSync(0,0);

	sceDisplayWaitVblankStart();
	sceGuDisplay(1);
	//Remplit l'image par dfaut (informations en lecture seule)
	memset(&osl_defaultBufferImage, 0, sizeof(osl_defaultBufferImage));
	osl_defaultBufferImage.sizeX = 480;
	osl_defaultBufferImage.sizeY = 272;
	osl_defaultBufferImage.realSizeX = 512;
	osl_defaultBufferImage.realSizeY = 272;
	osl_defaultBufferImage.pixelFormat = osl_currentPixelFormat;
	osl_defaultBufferImage.location = OSL_IN_VRAM;
	osl_defaultBufferImage.data = osl_curDrawBuf;
	osl_defaultBufferImage.sysSizeX = 512;
	osl_defaultBufferImage.sysSizeY = 512;
	osl_defaultBufferImage.totalSize = (0x22000*osl_currentResolutionBPP)>>3;
	oslSetImageTile(&osl_defaultBufferImage, 0,0, 480,272);
	osl_curBuf = &osl_defaultBufferImage;
	//Le buffer secondaire est identique,  un dtail prs (le buffer)
	memcpy(&osl_secondaryBufferImage, &osl_defaultBufferImage, sizeof(osl_secondaryBufferImage));
	osl_secondaryBufferImage.data = osl_curDispBuf;
	//A partir d'ici, on peut afficher des messages (fatal error et cie)
	oslStartDrawing();
	oslSetAlpha(OSL_FX_RGBA, 0);
	oslInitConsole();
}

void *osl_curDrawBuf = (void*)0, *osl_curDispBuf = (void*)0;

/*
	Cette fonction est trs lente sous windows. Sans les buffers auxiliaires, voici les oprations
	qu'elle effectue:
	Sauvegarde le contenu du drawbuffer courant vers l'image du drawbuffer courant
	Code spcial pour OSL_DEFAULT/OSL_SECONDARY_BUFFER
	Ecrit le contenu du nouveau drawbuffer sur la carte graphique
*/
void oslSetDrawBuffer(OSL_IMAGE *img)		{
#ifdef PSP
	osl_curBuf = img;
	sceGuDrawBuffer(img->pixelFormat, oslGetCachedPtr(img->data), img->sysSizeX);
#else
	//Mme image? Aucun intrt
	if (img == osl_curBuf)
		return;
	//On doit dsactiver (temporairement) le texturage 2D
	emuConfigure2DTransfer(1);
	//Lit les donnes du backbuffer dans l'image utilise jusque l comme drawbuffer
	if ((osl_curBuf != OSL_SECONDARY_BUFFER && osl_curBuf != OSL_DEFAULT_BUFFER) || (img != OSL_DEFAULT_BUFFER && img != OSL_SECONDARY_BUFFER))
		emuGlReadPixels(0, 272-osl_curBuf->sizeY, osl_curBuf->sysSizeX, osl_curBuf->sizeY, GL_RGBA, osl_curBuf->pixelFormat, osl_curBuf->data);
	//OPENGL SPECIFIC!!!!
	if (img == OSL_SECONDARY_BUFFER || OSL_DEFAULT_BUFFER->data == OSL_SECONDARY_BUFFER->data)		{
		glReadBuffer(GL_FRONT);
		glDrawBuffer(GL_FRONT);
	}
	else		{
		glReadBuffer(GL_BACK);
		glDrawBuffer(GL_BACK);
	}
	//Ecrit la nouvelle image sur le backbuffer
	if ((osl_curBuf != OSL_SECONDARY_BUFFER && osl_curBuf != OSL_DEFAULT_BUFFER) || (img != OSL_DEFAULT_BUFFER && img != OSL_SECONDARY_BUFFER))		{
		glRasterPos2i(0, 0);
		glPixelZoom(1, -1);
		glDrawPixels(img->sysSizeX, img->sizeY, GL_RGBA, emu_pixelPhysFormats[img->pixelFormat], img->data);
	}
	osl_curBuf = img;
	//Ractive si jamais
	emuConfigure2DTransfer(0);
#endif
}

/*
	Fonctions spciales PC
	Permet d'accder en soft  une image slectionne comme drawbuffer ou texture
*/
void oslLockImage(OSL_IMAGE *img)
{
	//Drawbuffer courant?
	if (img == osl_curBuf)			{
		oslSyncDrawing();
		//Avec OpenGL, il faut copier le contenu du drawbuffer sur l'image (vu qu'on va l'utiliser)
		#ifndef PSP
			//On doit dsactiver (temporairement) le texturage 2D
			int bTextureEnabled = glIsEnabled(GL_TEXTURE_2D), bBlendingEnabled = glIsEnabled(GL_BLEND);
			glDisable(GL_TEXTURE_2D);
			glDisable(GL_BLEND);
			//Lit les donnes du backbuffer dans l'image utilise jusque l comme drawbuffer
			emuGlReadPixels(0, 272-osl_curBuf->sizeY, osl_curBuf->sysSizeX, osl_curBuf->sizeY, GL_RGBA, osl_curBuf->pixelFormat, osl_curBuf->data);
			//Ractive si jamais
			if (bTextureEnabled)
				glEnable(GL_TEXTURE_2D);
			if (bBlendingEnabled)
				glEnable(GL_BLEND);
		#endif
	}
}

//A appeler une fois termin
void oslUnlockImage(OSL_IMAGE *img)
{
	if (img->location == OSL_IN_RAM)
		oslUncacheImage(img);
	//Texture courante?
	if (img->data == osl_curTexture)
		osl_curTexture = NULL;
	//Avec OpenGL, on recopie le contenu de l'image (modifie) vers le framebuffer
	#ifndef PSP
		if (img == osl_curBuf)			{
			//On doit dsactiver (temporairement) le texturage 2D
			int bTextureEnabled = glIsEnabled(GL_TEXTURE_2D), bBlendingEnabled = glIsEnabled(GL_BLEND);
			glDisable(GL_TEXTURE_2D);
			glDisable(GL_BLEND);
			//Lit les donnes du backbuffer dans l'image utilise jusque l comme drawbuffer
			glRasterPos2i(0, 0);
			glPixelZoom(1, -1);
			glDrawPixels(img->sysSizeX, img->sizeY, GL_RGBA, emu_pixelPhysFormats[img->pixelFormat], img->data);
			//Ractive si jamais
			if (bTextureEnabled)
				glEnable(GL_TEXTURE_2D);
			if (bBlendingEnabled)
				glEnable(GL_BLEND);
		}
	#endif
}

void oslSwapBuffers()
{
	//Seulement si le double buffer est activ
	if (osl_doubleBuffer)			{
		oslSetDrawBuffer(OSL_DEFAULT_BUFFER);
#ifdef PSP
		osl_curDispBuf = osl_defaultBufferImage.data;
		osl_secondaryBufferImage.data = osl_curDispBuf;
		osl_curDrawBuf = oslGetUncachedPtr(sceGuSwapBuffers());
#else
		//Sur PC, rien de tout a
		oslGetUncachedPtr(sceGuSwapBuffers());
#endif
	}
	//Met  jour l'image, assumant qu'il n'y a que l'adresse qui change entre les deux buffers
	osl_defaultBufferImage.data = osl_curDrawBuf;
}

void oslWaitVSync()
{
//	osl_vblCount++;
	sceDisplayWaitVblankStart();
}

void oslSetBilinearFilter(int enabled)
{
	osl_bilinearFilterEnabled = enabled;
	sceGuTexFilter(enabled?GU_LINEAR:GU_NEAREST, enabled?GU_LINEAR:GU_NEAREST);
}

void oslClearScreen(int backColor)		{
	sceGuClearColor(backColor);
	sceGuClear(GU_COLOR_BUFFER_BIT);
}

//Pas utilis pour le moment, pas test!
void oslSwizzleTexture(u8* out, const u8* in, unsigned int width, unsigned int height)
{
   unsigned int blockx, blocky;
   unsigned int j;
 
   unsigned int width_blocks = (width / 16);
   unsigned int height_blocks = (height / 8);
 
   unsigned int src_pitch = (width-16)/4;
   unsigned int src_row = width * 8;
 
   const u8* ysrc = in;
   u32* dst = (u32*)out;
 
#ifndef PSP
   memcpy(out, in, width * height);
   return;
#endif
   for (blocky = 0; blocky < height_blocks; ++blocky)
   {
      const u8* xsrc = ysrc;
      for (blockx = 0; blockx < width_blocks; ++blockx)
      {
         const u32* src = (u32*)xsrc;
         for (j = 0; j < 8; ++j)
         {
            *(dst++) = *(src++);
            *(dst++) = *(src++);
            *(dst++) = *(src++);
            *(dst++) = *(src++);
            src += src_pitch;
         }
         xsrc += 16;
     }
     ysrc += src_row;
   }
}

/*
	To use a swizzled texture pass GL_TRUE into the swizzled argument of sceGuTexMode: 

	sceGuTexMode(GU_PSM_8888,0,0,GL_TRUE);
	sceGuTexImage(0,widge,height,width,p_swizzled_data);
*/

void oslSetScreenClipping(int x0, int y0, int x1, int y1)		{
	sceGuScissor(x0, y0, x1, y1);
	sceGuEnable(GU_SCISSOR_TEST);
}

inline void oslFlushDataCache()		{
	sceKernelDcacheWritebackInvalidateAll();
}

#ifdef PSP
static void oslConfigureDialog(SceUtilityMsgDialogParams *dialog, size_t dialog_size)
{
    memset(dialog, 0, dialog_size);

    dialog->size = dialog_size;
    sceUtilityGetSystemParamInt(PSP_SYSTEMPARAM_ID_INT_LANGUAGE,
				&dialog->language); // Prompt language
    sceUtilityGetSystemParamInt(PSP_SYSTEMPARAM_ID_INT_UNKNOWN,
				&dialog->buttonSwap); // X/O button swap

    dialog->unknown[0] = 0x11;	// ???
    dialog->unknown[1] = 0x13;
    dialog->unknown[2] = 0x12;
    dialog->unknown[3] = 0x10;
}

void oslSystemMessage(const char *message)
{
    SceUtilityMsgDialogParams dialog;
	SceCtrlData ctl;
	int quit=0;

    oslConfigureDialog(&dialog, sizeof(dialog));
    dialog.unknown[10] = 1;
    strcpy(dialog.message, message);

    sceUtilityMsgDialogInitStart(&dialog);

    while(!quit) {
		oslStartDrawing();
		oslEndDrawing();
		switch(sceUtilityMsgDialogGetStatus()) {
			case 2:
				sceUtilityMsgDialogUpdate(2);
				break;
			    
			case 3:
				sceUtilityMsgDialogShutdownStart();
				break;
			    
			case 0:
				quit=1;
				break;
		}
		sceCtrlPeekBufferPositive( &ctl, 1 );
		sceDisplayWaitVblankStart();
		sceGuSwapBuffers();
    }
}
#endif

//state: 0: normal
void oslUIDrawButtonFrame(int x0, int y0, int w, int h, int state)
{
	#define x1 (x0+w)
	#define y1 (y0+h)
	//Cadre gris
	oslDrawFillRect(x0,y0,x1,y1,RGB(192,192,192));
	if (state == 1)		{
		//Gris en haut  gauche
		oslDrawRect(x0,y0,x1,y1,RGB(128,128,128));
		x0++, y0++, w-=2, h-=2;
	}
	//Cadre noir en bas  droite
	oslDrawLine(x1-1,y0,x1-1,y1,RGB(0,0,0));
	oslDrawLine(x0,y1-1,x1,y1-1,RGB(0,0,0));
	//Ombre grise en bas  droite
	oslDrawLine(x1-2,y0+1,x1-2,y1-1,RGB(128,128,128));
	oslDrawLine(x0+1,y1-2,x1-2,y1-2,RGB(128,128,128));
	//Reflet blanc en haut  gauche
	oslDrawLine(x0+1,y0+1,x1-2,y0+1,RGB(255,255,255));
	oslDrawLine(x0+1,y0+1,x0+1,y1-2,RGB(255,255,255));
	#undef x1
	#undef y1
}

unsigned int oslMessageBox(const char *text, const char *title, unsigned int flags)
{
	typedef struct		{
		int key, option;
		char text[32];
	} OSL_BUTTON_INFO;
	const int x0=240-150, y0=136-60, x1=240+150, y1=136+60;
	int btX, nbButtons, i;
	OSL_BUTTON_INFO buttons[3];
	unsigned char c;
	const unsigned char keys[]={' ',' ',' ',' ',' ',' ',' ',' ','L','R',' ',' ','^','o','x','#',' ',' ',' ',' ',' ',' ',' ',' '};
	OSL_IMAGE *curBuf = oslGetDrawBuffer();
	OSL_FONT *ft = osl_curFont;
	
	//Pour tre sr qu'un dessin est bien en cours
	oslStartDrawing();
	//Fonte systme
	if (!osl_sceFont)
		osl_sceFont = oslLoadFont(&osl_sceFontInfo);
	oslSetFont(osl_sceFont);
	//On dessine sur le buffer affich
	oslSetDrawBuffer(OSL_SECONDARY_BUFFER);
	//Pour le cadre de la bote: un bouton normal
	oslUIDrawButtonFrame(x0,y0,x1-x0,y1-y0,0);
	//Barre de titre
	oslDrawGradientRect(x0+3, y0+3, x1-3, y0+3+13, RGB(0,0,128), RGB(16,132,208), RGB(0,0,128), RGB(16,132,208));
	//Texte du titre (texte:blanc, fond:transparent)
	oslSetBkColor(RGBA(0,0,0,0));
	oslSetTextColor(RGB(255,255,255));
	oslSetScreenClipping(x0+3, y0+3, x1-3, y0+3+13);
	oslDrawString(x0+8, y0+6, title);
	oslResetScreenClipping();
	oslSetTextColor(RGB(0,0,0));
	oslDrawTextBox(x0+8, y0+22, x1-4, y1-30, text, 0);
	
	for (i=0;i<3;i++)		{
		//Plus rien?[i]
		if ((flags&511)==0)
			break;
		//Touche
		buttons[i].key = (flags&31);
		if (buttons[i].key >= 1 && buttons[i].key <= 24)
			c = keys[buttons[i].key-1];
		else
			c = ' ';
		buttons[i].option = (flags>>5)&15;
		switch (buttons[i].option)		{
			case OSL_MB_OK:
				sprintf(buttons[i].text, "%c Ok", c);
				break;
			case OSL_MB_CANCEL:
				sprintf(buttons[i].text, "%c Cancel", c);
				break;
			case OSL_MB_YES:
				sprintf(buttons[i].text, "%c Yes", c);
				break;
			case OSL_MB_NO:
				sprintf(buttons[i].text, "%c No", c);
				break;
			case OSL_MB_QUIT:
				sprintf(buttons[i].text, "%c Quit", c);
				break;
			default:
				strcpy(buttons[i].text, "");
		};
		flags >>= 9;
	}
	nbButtons = i;
	btX = ((x0+x1)/2)-45*nbButtons+5;

	//Boutons
	for (i=0;i<nbButtons;i++)		{
		oslUIDrawButtonFrame(btX+90*i, y1-30, 80, 21, 1);
		oslDrawString(btX+10+90*i,y1-23,buttons[i].text);
	}
	oslSetFont(ft);

//	oslEndDrawing();
//	oslSwapBuffers();
	while(!osl_quit)		{
		oslReadKeys();
		for (i=0;i<nbButtons;i++)			{
			if (osl_keys->pressed.value & 1<<(buttons[i].key-1))
				break;
		}
		if (i<nbButtons)				{
			if (buttons[i].option == OSL_MB_QUIT)
				oslQuit();
			else		{
				//Restaure le buffer original
				oslSetDrawBuffer(curBuf);
				oslReadKeys();
				return buttons[i].option;
			}
		}
		if (nbButtons==0)		{
			if (osl_keys->pressed.cross)		{
				oslSetDrawBuffer(curBuf);
				break;
			}
		}
		sceDisplayWaitVblankStart();
	}
	oslReadKeys();
	return 0;
}

//Console
/*void oslFatalError(char *erreur)		{
	SceCtrlData ctl;
	pspDebugScreenInit();
	pspDebugScreenSetXY(0,0);
	pspDebugScreenSetTextColor(0xFF);
	pspDebugScreenPrintf(erreur);
	while(1)		{
		sceCtrlReadBufferPositive( &ctl, 1 );
		if(ctl.Buttons & PSP_CTRL_START)
		{
			sceKernelExitGame();
		}
		sceDisplayWaitVblankStart();
		osl_curDrawBuf = sceGuSwapBuffers();
	}
}*/

int oslMeanBenchmarkTestEx(int startend, int slot)		{
	static int val[OSL_BENCH_SLOTS];
	static struct timeval start[OSL_BENCH_SLOTS];
	struct timeval end;
	static int curr_ms[OSL_BENCH_SLOTS], time[OSL_BENCH_SLOTS];

	if (startend == OSL_BENCH_INIT)			{
		val[slot]=0;
		time[slot]=0;
		curr_ms[slot]=0;
		gettimeofday(&start[slot],0);
	}
	else if (startend == OSL_BENCH_START)
		gettimeofday(&start[slot],0);
	else if (startend == OSL_BENCH_END)		{
		gettimeofday(&end,0);
		time[slot] += (end.tv_sec - start[slot].tv_sec) * 1000000;
		time[slot] += end.tv_usec - start[slot].tv_usec;
		val[slot]++;
		if (val[slot] >= OSL_BENCH_SAMPLES)
		{
			val[slot] = 0;
			curr_ms[slot] = time[slot] / OSL_BENCH_SAMPLES;
			time[slot] = 0;
		}
	}
/*	else if (startend == OSL_BENCH_DISPLAY)			{
		pspDebugScreenSetXY(0,0);
		pspDebugScreenPrintf("%i.%03i", curr_ms[slot]/1000, curr_ms[slot]%1000);
	}*/
	return curr_ms[slot];
}

int oslBenchmarkTestEx(int startend, int slot)		{
	static struct timeval start[OSL_BENCH_SLOTS];
	struct timeval end;
	static int time[OSL_BENCH_SLOTS];

	if (startend == OSL_BENCH_START)
		gettimeofday(&start[slot],0);
	else if (startend == OSL_BENCH_END)		{
		gettimeofday(&end,0);
		time[slot] = (end.tv_sec - start[slot].tv_sec) * 1000000;
		time[slot] += end.tv_usec - start[slot].tv_usec;
	}
	return time[slot];
}


void oslEndGfx()
{
	sceGuTerm();
}

void oslQuit()
{
	sceKernelExitGame();
}

//Va de 1*couleur1  15/16*couleur2 + 1/16*couleur1 (pas jusqu'au fond, limite hardware). Idem pour couleur2 et couleur4. Dessiner un rectangle  l'envers pour prioriser l'autre coin (couleur1 ou couleur3), cd x1,y0,x0,y1.
void oslDrawGradientRect(int x0, int y0, int x1, int y1, OSL_COLOR c1, OSL_COLOR c2, OSL_COLOR c3, OSL_COLOR c4)
{
	OSL_LINE_VERTEX* vertices;

	vertices = (OSL_LINE_VERTEX*)sceGuGetMemory(4 * sizeof(OSL_LINE_VERTEX));
//	sceGuShadeModel(GU_SMOOTH);

	vertices[0].color = c1;
	vertices[0].x = x0;
	vertices[0].y = y0;
	vertices[0].z = 0;

	vertices[1].color = c2;
	vertices[1].x = x1;
	vertices[1].y = y0;
	vertices[1].z = 0;

	vertices[2].color = c3;
	vertices[2].x = x0;
	vertices[2].y = y1;
	vertices[2].z = 0;

	vertices[3].color = c4;
	vertices[3].x = x1;
	vertices[3].y = y1;
	vertices[3].z = 0;

	sceGuDisable(GU_TEXTURE_2D);
	sceGuDrawArray(GU_TRIANGLE_STRIP, GU_COLOR_8888|GU_VERTEX_16BIT|GU_TRANSFORM_2D, 4, 0, vertices);
	sceGuEnable(GU_TEXTURE_2D);
}

#ifdef PSP
	/* Exit callback */
	int oslStandardExitCallback(int arg1, int arg2, void *common)
	{
		osl_quit = 1;
	//	sceKernelExitGame();
		return 0;
	}

	int oslStandardPowerCallback(int unknown, int pwrflags,void *common){
		int cbid;
		if (osl_powerCallback)
			osl_powerCallback(unknown, pwrflags, common);
		cbid = sceKernelCreateCallback("Power Callback", oslStandardPowerCallback, NULL);
		scePowerRegisterCallback(0, cbid);
		return 0;
	}

	/* Callback thread */
	int oslCallbackThread(SceSize args, void *argp)
	{
		int cbid;

		cbid = sceKernelCreateCallback("Exit Callback", oslStandardExitCallback, NULL);
		sceKernelRegisterExitCallback(cbid);
		cbid = sceKernelCreateCallback("Power Callback", oslStandardPowerCallback,NULL );
		scePowerRegisterCallback(0, cbid );

		sceKernelSleepThreadCB();

		return 0;
	}

	/* Sets up the callback thread and returns its thread id */
	int oslSetupCallbacks()
	{
		int thid = 0;

		thid = sceKernelCreateThread("update_thread", oslCallbackThread, 0x11, 0xFA0, 0, 0);
		if(thid >= 0)
		{
			sceKernelStartThread(thid, 0, 0);
		}

		return thid;
	}
#endif

volatile int osl_vblCount=0, osl_vblCallCount=0, osl_skip=0, osl_nbSkippedFrames=0;

void oslVblankInterrupt(int sub, void *parg)
{
	osl_vblCount++;
}

int osl_maxFrameskip=0, osl_vsyncEnabled=0, osl_frameskip=0;

void oslInit(int useOwnCallbacks)
{
	void *arg = 0;
	int i;

	osl_keys = &osl_intKeys;
	
	osl_quit = 0;
	osl_vblCount = 0;
	osl_vblCallCount = 0;
	osl_skip = 0;
	osl_nbSkippedFrames = 0;
	osl_maxFrameskip=5;
	osl_vsyncEnabled=4;
	osl_frameskip=0;

	//Configure l'autorepeat (il n'y en a pas au dbut)
	oslSetKeyAutorepeat(OSL_KEYMASK_UP|OSL_KEYMASK_RIGHT|OSL_KEYMASK_DOWN|OSL_KEYMASK_LEFT|OSL_KEYMASK_R|OSL_KEYMASK_L,0,0);
	
#ifdef PSP
	if (!useOwnCallbacks)
		oslSetupCallbacks();

	sceKernelRegisterSubIntrHandler(PSP_VBLANK_INT,osl_vblInterruptNumber,oslVblankInterrupt,arg);
	sceKernelEnableSubIntr(PSP_VBLANK_INT,osl_vblInterruptNumber);
#endif
	for (i=0;i<OSL_BENCH_SLOTS;i++)
		oslMeanBenchmarkTestEx(OSL_BENCH_INIT, i);

	//Initialise l'mulation
#ifndef PSP
	emuInitGfx();
	emuStartDrawing();
	emuInitGL();
#endif
}

#define OSL_SYSTEM_BENCHMARK_ENABLED

void oslSysBenchmarkDisplay()			{
#ifdef OSL_SYSTEM_BENCHMARK_ENABLED
	int ms4, ms5, ms6;
	ms4 = oslMeanBenchmarkTestEx(OSL_BENCH_GET, 4);
	ms5 = oslMeanBenchmarkTestEx(OSL_BENCH_GET, 5);
	ms6 = oslMeanBenchmarkTestEx(OSL_BENCH_GET, 6);
	oslSetTextColor(RGB(255,255,255));
	oslSetBkColor(RGBA(0,0,0,0x80));
	oslPrintf_xy(0,0, "%i.%03i + %i.%03i = %i.%03i", ms4/1000, ms4%1000, ms5/1000, ms5%1000, ms6/1000, ms6%1000);
#endif
}

/*
	Frameskip:
				0: pas de frameskip (normal)
				1: frameskip normal
				>1: dpend de vsync, saute 1 frame sur X
	
	Max frameskip:
				>=1: Frameskip maximum autoris
	VSync:
				0: pas de VSync
				1: vsync active
				+4: si on rajoute 4, avec un frameskip >1, synchronise au framerate souhait, par ex. 2 -> 30 fps
				+0: sinon, fixe le frameskip minimum (ex. avec 2, le jeu tournera  60 fps, 30 images par seconde)
				+8: synchro maximale (impression de triple buffering), sans vsync
				+16: pas de swapbuffers
	Exemples:
		//30 fps (pas de frameskip)
		oslSyncFrameEx(2,0,0);
		//30 fps, jeu  60, frameskip max de 2, c'est--dire pas plus d'une frame skippe pour une affiche
		oslSyncFrameEx(2,2,4);
		//synchronise  60 fps
		oslSyncFrameEx(0,0,0);
*/
int oslSyncFrameEx(int frameskip, int max_frameskip, int vsync)
{
	#ifdef OSL_SYSTEM_BENCHMARK_ENABLED
	int lastOslSkip;
	#endif
	int i, wasDrawing=0;
	if (osl_isDrawingStarted)
		oslEndDrawing(), wasDrawing=1;
	if (frameskip==0)			{
		#ifdef OSL_SYSTEM_BENCHMARK_ENABLED
		oslMeanBenchmarkTestEx(OSL_BENCH_END, 4);
		oslMeanBenchmarkTestEx(OSL_BENCH_END, 6);
		#endif
		//Dans les temps -> vsync
		i = osl_vblCount;
		if (vsync || osl_vblCallCount+1 > i)			{
			oslWaitVSync();
			i++;
		}
		osl_vblCallCount = i;
		osl_skip = 0;
		#ifdef OSL_SYSTEM_BENCHMARK_ENABLED
		oslMeanBenchmarkTestEx(OSL_BENCH_START, 4);
		oslMeanBenchmarkTestEx(OSL_BENCH_START, 6);
		#endif
		if (!(vsync & 16))
			oslSwapBuffers();
	}
	else	{
		if (vsync&4)
			osl_vblCallCount++;
		else
			osl_vblCallCount+=frameskip;
		#ifdef OSL_SYSTEM_BENCHMARK_ENABLED
		lastOslSkip = osl_skip;
		if (osl_skip)
			oslMeanBenchmarkTestEx(OSL_BENCH_END, 5);
		else			{
			oslMeanBenchmarkTestEx(OSL_BENCH_END, 4);
		}
		#endif
		//La rfrence quand vsync = 0
		i=((vsync&1) && !osl_skip && !(vsync&8))?1:0;
		//On est en retard?
		if ((osl_vblCount+i > osl_vblCallCount || (vsync&4 && osl_vblCallCount%frameskip)) && osl_nbSkippedFrames < max_frameskip-1)			{
			if (!osl_skip)		{		//La frame a t dessine -> on l'affiche
				#ifdef OSL_SYSTEM_BENCHMARK_ENABLED
					oslMeanBenchmarkTestEx(OSL_BENCH_END, 6);
				#endif
				if (vsync&1)						//Activer pour avoir vraiment la VSync
					oslWaitVSync();
				if (!(vsync & 16))
					oslSwapBuffers();
				#ifdef OSL_SYSTEM_BENCHMARK_ENABLED
					oslMeanBenchmarkTestEx(OSL_BENCH_START, 6);
				#endif
			}
			osl_nbSkippedFrames++;
			//Dernire fois -> la prochaine c'est en-dessous
			if (frameskip > 1 && osl_vblCallCount%frameskip == frameskip - 1)
				osl_skip = 0;
			else
				osl_skip = 1;
		}
		else		{
			#ifdef OSL_SYSTEM_BENCHMARK_ENABLED
				if (!osl_skip)
					oslMeanBenchmarkTestEx(OSL_BENCH_END, 6);
			#endif
			if (vsync&1 && !osl_skip)						//Activer pour avoir vraiment la VSync
				oslWaitVSync();
			//Dans les temps
			i = osl_vblCount;
			while (i < osl_vblCallCount + ((vsync & 8) ? (1 - osl_skip) : (0)))		{
				oslWaitVSync();
				i++;
			}
			//La rfrence (meilleur frameskip), mais bidouillage
/*			if (osl_vblCount < osl_vblCallCount)		{
				do	{
					oslWaitVSync();
				} while (osl_vblCount+1 <=osl_vblCallCount);
			}*/
			if (!osl_skip)			{
				if (!(vsync & 16))
					oslSwapBuffers();
			}
			#ifdef OSL_SYSTEM_BENCHMARK_ENABLED
				if (!osl_skip)
					oslMeanBenchmarkTestEx(OSL_BENCH_START, 6);
			#endif
			//Trop de frameskip tue le frameskip
			if (osl_nbSkippedFrames >= max_frameskip-1)
				osl_vblCallCount = osl_vblCount;
			osl_nbSkippedFrames=0;
			osl_skip = 0;
			//Bidouille pour le frameskip fix -> on repasse en-dessus
			if (vsync&4 && frameskip > 1 && osl_vblCallCount%frameskip == 0)
				osl_skip = 1;
		}
		#ifdef OSL_SYSTEM_BENCHMARK_ENABLED
		if (osl_skip)
			oslMeanBenchmarkTestEx(OSL_BENCH_START, 5);
		else
			oslMeanBenchmarkTestEx(OSL_BENCH_START, 4);
		#endif
	}
	if (wasDrawing)
		oslStartDrawing();
	return osl_skip;
}

/*int oslSyncFrameEx(int frameskip, int max_frameskip, int vsync)
{
	osl_vblCallCount++;
	if (osl_vblCount > osl_vblCallCount)			{
		if (!osl_skip)		{
//			if (vsync)
//				oslWaitVSync();
			oslSwapBuffers();
		}
		osl_skip = 1;
	}
	else	{
		if (osl_vblCount <= osl_vblCallCount)		{
			do	{
				oslWaitVSync();
			} while (osl_vblCount+1 <=osl_vblCallCount);
		}
		if (!osl_skip)			{
			oslSwapBuffers();
		}
		osl_nbSkippedFrames=0;
		osl_skip = 0;
	}

	return osl_skip;
}*/

int oslConvertColor(int pfDst, int pfSrc, int color)		{
	int r=0, g=0, b=0, a=0;
	if (pfSrc == pfDst)
		return color;
	if (pfSrc == OSL_PF_8888)
		oslRgbaGet8888(color, r, g, b, a);
	else if (pfSrc == OSL_PF_5650)
		oslRgbGet5650f(color, r, g, b), a = 0xff;
	else if (pfSrc == OSL_PF_5551)
		oslRgbaGet5551f(color, r, g, b, a);
	else if (pfSrc == OSL_PF_4444)
		oslRgbaGet4444f(color, r, g, b, a);
	if (pfDst == OSL_PF_8888)
		color = RGBA(r, g, b, a);
	else if (pfDst == OSL_PF_5650)
		color = RGB16(r, g, b);
	else if (pfDst == OSL_PF_5551)
		color = RGBA15(r, g, b, a);
	else if (pfDst == OSL_PF_4444)
		color = RGBA12(r, g, b, a);
	return color;
}

OSL_IMAGE *oslCreateImageTile(OSL_IMAGE *img, int offsetX0, int offsetY0, int offsetX1, int offsetY1)
{
	OSL_IMAGE *newImg;
	newImg = (OSL_IMAGE*)malloc(sizeof(OSL_IMAGE));
	memcpy(newImg, img, sizeof(OSL_IMAGE));
	newImg->isCopy = 1;
	oslSetImageTile(newImg, offsetX0, offsetY0, offsetX1, offsetY1);
	return newImg;
}

OSL_IMAGE *oslCreateImageTileSize(OSL_IMAGE *img, int offsetX0, int offsetY0, int width, int height)
{
	OSL_IMAGE *newImg;
	newImg = (OSL_IMAGE*)malloc(sizeof(OSL_IMAGE));
	memcpy(newImg, img, sizeof(OSL_IMAGE));
	newImg->isCopy = 1;
	oslSetImageTileSize(newImg, offsetX0, offsetY0, width, height);
	return newImg;
}

//Dessine une tile de la texture slectionne. Eviter d'utiliser  l'extrieur.
void oslDrawTile(int u, int v, int x, int y, int tX, int tY)
{
	OSL_FAST_VERTEX *vertices;
	vertices = (OSL_FAST_VERTEX*)sceGuGetMemory(2 * sizeof(OSL_FAST_VERTEX));

	vertices[0].u = u;
	vertices[0].v = v;
	vertices[0].x = x;
	vertices[0].y = y;
	vertices[0].z = 0;

	vertices[1].u = u+tX;
	vertices[1].v = v+tY;
	vertices[1].x = x+tX;
	vertices[1].y = y+tY;
	vertices[1].z = 0;

	sceGuDrawArray(GU_SPRITES,GU_TEXTURE_16BIT|GU_VERTEX_16BIT|GU_TRANSFORM_2D,2,0,vertices);
}

/*
	PALETTE
*/
OSL_PALETTE *oslCreatePalette(int size, short pixelFormat)
{
	OSL_PALETTE *p;
	p = (OSL_PALETTE*)malloc(sizeof(OSL_PALETTE));
	if (!p)
		return NULL;
	p->pixelFormat = pixelFormat;
	p->nElements = size;
	p->data = memalign(16, size * osl_pixelWidth[pixelFormat]);
	//Allocation rate
	if (!p->data)			{
		free(p);
		return NULL;
	}
	memset(p->data, 0, size * osl_pixelWidth[pixelFormat]);
	return p;
}

OSL_PALETTE *oslLoadPalette(void *data, int size, short pixelFormat)
{
	OSL_PALETTE *p;
	p = (OSL_PALETTE*)malloc(sizeof(OSL_PALETTE));
	if (!p)
		return NULL;
	p->pixelFormat = pixelFormat;
	p->nElements = size;
	p->data = data;
	return p;
}

/*
	MAP
*/

//tileX, tileY, img->sizeX doivent tre des puissances de deux!
void oslDrawMapSimple(OSL_MAP *m)
{
	int x, y, v, ttX=0, i, sX, sY, tX=0, tY=0, mX, mY, dX, bY, dsX, dsY;
	u16 *map = (u16*)m->map;
	OSL_FAST_VERTEX *vertices, *vptr;
	int nbVertices;

	oslSetTexture(m->img);
	//Calcule le drawSize s'il n'est pas fourni
	if (m->drawSizeX < 0 || m->drawSizeY < 0)			{
		dsX = osl_curBuf->sizeX/m->tileX+1;
		if (osl_curBuf->sizeX%m->tileX)		dsX++;
		dsY = osl_curBuf->sizeY/m->tileY+1;
		if (osl_curBuf->sizeY%m->tileY)		dsY++;
	}
	else
		dsX = m->drawSizeX, dsY = m->drawSizeY;

	//Trouve les puissances de deux optimises
	for (i=3;i<=9;i++)			{
		if (ttX == 0 && m->img->sysSizeX <= 1<<i)
			ttX = i;
		if (tX == 0 && m->tileX <= 1<<i)
			tX = i;
		if (tY == 0 && m->tileY <= 1<<i)
			tY = i;
	}

	sX = m->scrollX&((1<<tX)-1);
	sY = m->scrollY&((1<<tY)-1);
	dX = (m->scrollX>>tX)%m->mapSizeX;
	mY = (m->scrollY>>tY)%m->mapSizeY;
	//Pour parer au modulo ngatif
	if (dX < 0)		dX += m->mapSizeX;
	if (mY < 0)		mY += m->mapSizeY;

	for (y=0;y<dsY;y++)			{
		bY = m->mapSizeX*mY;
		mX = dX;
		vertices = (OSL_FAST_VERTEX*)sceGuGetMemory(dsX * 2 * sizeof(OSL_FAST_VERTEX));
		vptr = vertices;
		nbVertices = 0;
		for (x=0;x<dsX;x++)			{
			v = map[bY+mX];
			//Plus optimis
			if (v)				{
				vertices[nbVertices].u = ((v<<tX)&((1<<ttX)-1));
				vertices[nbVertices].v = ((v<<tX)>>ttX)<<tY;
				vertices[nbVertices].x = (x<<tX)-sX;
				vertices[nbVertices].y = (y<<tY)-sY;
				vertices[nbVertices].z = 0;
				nbVertices ++;
				vertices[nbVertices].u = ((v<<tX)&((1<<ttX)-1)) + m->tileX;
				vertices[nbVertices].v = (((v<<tX)>>ttX)<<tY) + m->tileY;
				vertices[nbVertices].x = ((x<<tX)-sX) + m->tileX;
				vertices[nbVertices].y = ((y<<tY)-sY) + m->tileY;
				vertices[nbVertices].z = 0;
				nbVertices ++;
			}
			mX++;
			if (mX >= m->mapSizeX)
				mX -= m->mapSizeX;
		}
		//Dessine
		if (nbVertices > 0)
			sceGuDrawArray(GU_SPRITES,GU_TEXTURE_16BIT|GU_VERTEX_16BIT|GU_TRANSFORM_2D, nbVertices, 0, vertices);
		mY++;
		if (mY >= m->mapSizeY)
			mY -= m->mapSizeY;
	}
}

void oslDrawMap(OSL_MAP *m)
{
	int x, y, v, sX, sY, mX, mY, dX, bY, dsX, dsY;
	u16 *map = (u16*)m->map;

	oslSetTexture(m->img);
	if (m->drawSizeX < 0 || m->drawSizeY < 0)			{
		dsX = osl_curBuf->sizeX/m->tileX+1;
		if (osl_curBuf->sizeX%m->tileX)		dsX++;
		dsY = osl_curBuf->sizeY/m->tileY+1;
		if (osl_curBuf->sizeY%m->tileY)		dsY++;
	}
	else
		dsX = m->drawSizeX, dsY = m->drawSizeY;

	sX = m->scrollX%m->tileX;
	sY = m->scrollY%m->tileY;
	//Pour parer au modulo ngatif
	if (sX < 0)		sX += m->tileX;
	if (sY < 0)		sY += m->tileY;
	dX = (((m->scrollX)<0?(m->scrollX-m->tileX+1):(m->scrollX))/m->tileX)%m->mapSizeX;
	mY = (((m->scrollY)<0?(m->scrollY-m->tileY+1):(m->scrollY))/m->tileY)%m->mapSizeY;
	//Pour parer au modulo ngatif
	if (dX < 0)		dX += m->mapSizeX;
	if (mY < 0)		mY += m->mapSizeY;

	for (y=0;y<dsY;y++)			{
		bY = m->mapSizeX*mY;
		mX = dX;
		for (x=0;x<dsX;x++)			{
			v = map[bY+mX];
			//Plus comprhensible
			if (v)			{
				oslDrawTile((v*m->tileX)%m->img->sizeX,
					((v*m->tileX)/m->img->sizeX)*m->tileY,
					x*m->tileX-sX,
					y*m->tileY-sY,
					m->tileX,
					m->tileY);
			}
			mX++;
			if (mX >= m->mapSizeX)
				mX -= m->mapSizeX;
		}
		mY++;
		if (mY >= m->mapSizeY)
			mY -= m->mapSizeY;
	}
}

OSL_MAP *oslCreateMap(OSL_IMAGE *img, void *map_data, int tileX, int tileY, int mapSizeX, int mapSizeY, int map_format)
{
	OSL_MAP *m;
	m = (OSL_MAP*)malloc(sizeof(OSL_MAP));
	if (!m)
		return NULL;
	if (map_format != OSL_MF_U16)		{
		oslFatalError("Invalid map format");
		free(m);
		return NULL;
	}
	m->format = map_format;
	m->img = img;
	m->map = map_data;
	m->tileX = tileX;
	m->tileY = tileY;
	m->mapSizeX = mapSizeX;
	m->mapSizeY = mapSizeY;
	m->scrollX = m->scrollY = 0;
	m->drawSizeX = -1;
	m->drawSizeY = -1;
	return m;
}

/*
	CONTROLLER
*/

OSL_CONTROLLER osl_intKeys;

OSL_CONTROLLER *oslReadKeys()
{
	SceCtrlData ctl;
	
	sceCtrlSetSamplingCycle(0);
	sceCtrlSetSamplingMode(1);
	sceCtrlPeekBufferPositive( &ctl, 1 );
	/*
		CODE AUTO-REPEAT
	*/
	if (osl_keys->autoRepeatInterval > 0)			{					//Auto repeat activ?
		//Si a change -> compteur  zro
		if (osl_keys->held.value != ctl.Buttons)
			osl_keys->autoRepeatCounter=0;
		else			{
			osl_keys->autoRepeatCounter++;
			if (osl_keys->autoRepeatCounter >= osl_keys->autoRepeatInit)			{
				//AutoRepeat dclench -> dclenchement toutes les autoRepeatInterval coups
				if ((osl_keys->autoRepeatCounter - osl_keys->autoRepeatInit) % osl_keys->autoRepeatInterval == 0)
					osl_keys->held.value &= ~osl_keys->autoRepeatMask;
			}
		}
	}
	osl_keys->pressed.value = ~osl_keys->held.value & ctl.Buttons;
	osl_keys->held.value = ctl.Buttons;
	osl_keys->analogX = (signed)ctl.Lx-128;
	osl_keys->analogY = (signed)ctl.Ly-128;
	return osl_keys;
}

void oslFlushKey()
{
	oslReadKeys();
}

int oslKbhit()
{
	OSL_CONTROLLER *keys;
	int i, j, k;
	keys = oslReadKeys();
	k = 0;
	j = 0;
	for (i=0;i<24;i++)		{
		if (keys->pressed.value & (1<<i))			{
			k |= (i+1)<<j;
			j+=8;
		}
	}
	return k;
}

int oslWaitKey()
{
	int i;
	while(!(i=oslKbhit()) && !osl_quit)
		oslWaitVSync();
	return i;
}

