#ifndef OSLIB_H
#define OSLIB_H

#ifdef PSP
	#include <pspkernel.h>
	#include <pspdisplay.h>
	#include <pspdebug.h>
#else
	#include "emu.h"
#endif
#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <math.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#ifdef PSP
	#include <pspctrl.h>
	#include <psputility.h>
	#include <pspgu.h>
	#include <psppower.h>
	#include <pspiofilemgr.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif
#include "audio.h"
//#include "usb.h"

/*
	Dfinitions
*/
//Alloue un bloc de RAM align
void *memalign(size_t, size_t);
#ifdef PSP
	#define OSL_UVRAM_BASE 0x04000000
#else
	extern u8 *OSL_UVRAM_BASE;
	#define alloca _alloca
//	void *_alloca(size_t size);
#endif

typedef struct
{
	float u, v;
	float x, y, z;
} OSL_PRECISE_VERTEX;

typedef struct
{
	unsigned short u, v;
	short x, y, z;
} OSL_FAST_VERTEX;

typedef struct
{
	unsigned long color;
	short x, y, z;
} OSL_LINE_VERTEX;

typedef struct
{
	float u, v;
	short x, y, z;
} OSL_UVFLOAT_VERTEX;

typedef unsigned long OSL_COLOR;

#define OSL_PALETTEDATA16 unsigned short __attribute__((aligned(16)))
#define OSL_PALETTEDATA32 unsigned long __attribute__((aligned(16)))

typedef struct			{
	short pixelFormat, nElements;
	void *data;
} OSL_PALETTE;

#define bool short

typedef struct		{
	//public
	int x, y;								//Positions
	int stretchX, stretchY;					//Taille finale (tire)
	//Morceau
	float offsetX0, offsetY0, offsetX1, offsetY1;
	//Rotation
	int centerX, centerY;					//Centre de rotation
	float angle;							//Angle (rotation)
	//Paramtres
	bool autoStrip;							//Stripping auto (incompatible avec rotation)
	OSL_PALETTE *palette;					//Palette pour les modes 4 et 8 bits

	//protected
	int sizeX, sizeY;						//Taille relle
	int sysSizeX, sysSizeY;					//Taille aligne
	int realSizeX, realSizeY;				//Taille si align
	void *data;								//Image en mmoire
	bool isCopy;							//Est une copie d'une autre image (=ne pas la librer)
	bool isSwizzled;						//Est swizzle (optimise)
	int totalSize;							//Taille en octets
	short location, pixelFormat;
} OSL_IMAGE;

typedef struct		{
	OSL_IMAGE *img;
	void *map;
	int scrollX, scrollY;
	int tileX, tileY;
	int drawSizeX, drawSizeY;
	int mapSizeX, mapSizeY;
	int format;
} OSL_MAP;

typedef struct		{
	union		{
		struct		{
			int select:1, reserved1:2, start:1;
			int up:1, right:1, down:1, left:1;
			int L:1, R:1, reserved2:2;
			int triangle:1, circle:1, cross:1, square:1;
			int home:1, hold:1, reserved3:5, note:1;
		};
		unsigned int value;
	} held;									//Touches enfonces (maintenues)
	union		{
		struct		{
			int select:1, reserved1:2, start:1;
			int up:1, right:1, down:1, left:1;
			int L:1, R:1, reserved2:2;
			int triangle:1, circle:1, cross:1, square:1;
			int home:1, hold:1, reserved3:5, note:1;
		};
		unsigned int value;
	} pressed;								//Touches presses
	int autoRepeatInit;						//Temps pour l'initialisation de l'autorepeat
	int autoRepeatInterval;					//Intervalle de dclenchement de l'autorepeat
	int autoRepeatMask;						//Touches concernes par l'autorepeat
	int autoRepeatCounter;					//Compteur (interne)
	signed char analogX;					//Position horizontale du stick (-128  +127)
	signed char analogY;					//Position verticale du stick
} OSL_CONTROLLER;

/*
	Macros
*/

// *** Gnral ***
#define oslUncacheData(data,size)		sceKernelDcacheWritebackInvalidateRange(data, size);

#ifndef PSP
	#undef RGB
#endif

// *** Couleur ***
#define RGB12(r,v,b)	((((b)>>4)<<8) | (((v)>>4)<<4) | ((r)>>4) | (0xf<<12))
#define RGBA12(r,v,b,a)	((((a)>>4)<<12) | (((b)>>4)<<8) | (((v)>>4)<<4) | ((r)>>4))
#define RGB15(r,v,b)	((((b)>>3)<<10) | (((v)>>3)<<5) | ((r)>>3) | (1<<15))
#define RGBA15(r,v,b,a)	((((a)>>7)<<15) | (((b)>>3)<<10) | (((v)>>3)<<5) | ((r)>>3))
#define RGB16(r,v,b)	((((b)>>3)<<11) | (((v)>>2)<<5) | ((r)>>3))
#define RGB(r,v,b)		((r) | ((v)<<8) | ((b)<<16) | (0xff<<24))
#define RGBA(r,v,b,a)	((r) | ((v)<<8) | ((b)<<16) | ((a)<<24))

//Rcupration de couleur
#define oslRgbaGet8888(data, r, g, b, a)		((r)=((data)&0xff), (g)=(((data)>>8)&0xff), (b)=(((data)>>16)&0xff), (a)=(((data)>>24)&0xff))
#define oslRgbGet5650(data, r, g, b)			((r)=((data)&0x1f)<<3, (g)=(((data)>>5)&0x3f)<<2, (b)=(((data)>>11)&0x1f)<<3)
#define oslRgbaGet5551(data, r, g, b, a)		((r)=((data)&0x1f)<<3, (g)=(((data)>>5)&0x1f)<<3, (b)=(((data)>>10)&0x1f)<<3, (a)=(((data)>>15)&0x1)<<7)
#define oslRgbaGet4444(data, r, g, b, a)		((r)=((data)&0xf)<<4, (g)=(((data)>>4)&0xf)<<4, (b)=(((data)>>8)&0xf)<<4, (a)=(((data)>>12)&0xf)<<4)
//Prcises
#define oslRgbGet5650f(data, r, g, b)			((r)=(((data)&0x1f)*255)/31, (g)=((((data)>>5)&0x3f)*255)/63, (b)=((((data)>>11)&0x1f)*255)/31)
#define oslRgbaGet5551f(data, r, g, b, a)		((r)=(((data)&0x1f)*255)/31, (g)=((((data)>>5)&0x1f)*255)/31, (b)=((((data)>>10)&0x1f)*255)/31, (a)=(((data)>>15)&0x1)*255)
#define oslRgbaGet4444f(data, r, g, b, a)		((r)=(((data)&0xf)*255)/15, (g)=((((data)>>4)&0xf)*255)/15, (b)=((((data)>>8)&0xf)*255)/15, (a)=((((data)>>12)&0xf)*255)/15)

// *** Benchmark ***
//Lance un benchmark
#define oslBenchmarkTest(startend)	oslBenchmarkTestEx(startend, 0)

// *** Image ***
//Donne les coordonnes d'une image de manire  ce qu'avec un angle de 0 le haut-gauche de l'image se trouve  la la position x,y indique
#define oslImageRotMoveX(img,x)			((((x)+(img)->centerX*(img)->stretchX)/(img)->sizeX))
#define oslImageRotMoveY(img,y)			((((y)+(img)->centerY*(img)->stretchY)/(img)->sizeY))
#define oslImageSetRotCenter(img)		((img)->centerX=(int)oslAbs((img)->offsetX1-(img)->offsetX0)>>1, (img)->centerY=(int)oslAbs((img)->offsetY1-(img)->offsetY0)>>1)
#define oslGetImageLine(img,y)			((char*)((img)->data) + (y)*(((img)->realSizeX * osl_pixelWidth[(img)->pixelFormat])>>3))
#define oslGetImagePixelAdr(img,x,y)	((char*)((img)->data) + ((((y)*(img)->realSizeX + (x)) * osl_pixelWidth[(img)->pixelFormat])>>3))
#define oslGetImageSizeX(img)			((int)oslAbs((img)->offsetX1-(img)->offsetX0))
#define oslGetImageSizeY(img)			((int)oslAbs((img)->offsetY1-(img)->offsetY0))
#define oslGetUncachedPtr(adr)			((void*)((int)(adr)|0x04000000))
#define oslGetCachedPtr(adr)			((void*)((int)(adr)&(~0x04000000)))
//Ncessaire avant de pouvoir dessiner ou manier l'image ( appeler aprs une modification du contenu de  img->data  la main)
#define oslUncacheImage(img) 			sceKernelDcacheWritebackInvalidateRange((img)->data, (img)->totalSize)

#define oslAbs(x)  (((x)<0)?(-(x)):(x))
#ifdef PSP
	//Dessine une image aux positions x,y
	#define oslDrawImageXY(img,px,py)	({ (img)->x=(px), (img)->y=(py); oslDrawImage(img); })
	//Dessine une image rapidement (sans le redimensionnement et la rotation)
	#define oslDrawImageSimpleXY(img,px,py)	({ (img)->x=(px), (img)->y=(py); oslDrawImageSimple(img); })
	//Rgle le rectangle source de l'image (offset)
	//#define oslSetImageTile(img,x0,y0,x1,y1)		({ (img)->offsetX0=vfpu_i2f(x0), (img)->offsetY0=vfpu_i2f(y0), (img)->offsetX1=vfpu_i2f(x1), (img)->offsetY1=vfpu_i2f(y1); (img)->stretchX = vfpu_isubf((img)->offsetX1, (img)->offsetX0), (img)->stretchY = vfpu_isubf((img)->offsetY1, (img)->offsetY0); })
	#define oslSetImageTile(img,x0,y0,x1,y1)		({ (img)->offsetX0=(float)x0, (img)->offsetY0=(float)y0, (img)->offsetX1=(float)x1, (img)->offsetY1=(float)y1; (img)->stretchX = oslAbs((int)((float)((img)->offsetX1) - (float)((img)->offsetX0))), (img)->stretchY = oslAbs((int)((float)((img)->offsetY1) - (float)((img)->offsetY0))); })
	//Idem, mais x1 et y1 sont la taille de tile
	#define oslSetImageTileSize(img,x0,y0,x1,y1)		({ (img)->offsetX0=(float)(x0), (img)->offsetY0=(float)(y0), (img)->offsetX1=(float)(x0)+(float)(x1), (img)->offsetY1=(float)(y0)+(float)(y1), (img)->stretchX = (int)(x1), (img)->stretchY = (int)(y1); })
	//#define oslSetImageTileSize(img,x0,y0,x1,y1)	({(img)->offsetX0=vfpu_i2f(x0), (img)->offsetY0=vfpu_i2f(y0); (img)->offsetX1=(img)->offsetX0+vfpu_i2f(x1), (img)->offsetY1=(img)->offsetY0+vfpu_i2f(y1); (img)->stretchX = x1, (img)->stretchY = y1; })
	#define oslResetImageTile(img)					({ (img)->offsetX0=0, (img)->offsetY0=0, (img)->offsetX1=(img)->sizeX, (img)->offsetY1=(img)->sizeY; (img)->stretchX = (img)->sizeX, (img)->stretchY = (img)->sizeY; })
	#define oslMirrorImageH(img)					({ float ___tmp;  ___tmp = (img)->offsetX0; (img)->offsetX0 = (img)->offsetX1; (img)->offsetX1 = ___tmp; })
	#define oslMirrorImageV(img)					({ float ___tmp;  ___tmp = (img)->offsetY0; (img)->offsetY0 = (img)->offsetY1; (img)->offsetY1 = ___tmp; })
#else
	#define oslDrawImageXY(img,px,py)				{ (img)->x=(px), (img)->y=(py); oslDrawImage(img); }
	#define oslDrawImageSimpleXY(img,px,py)			{ (img)->x=(px), (img)->y=(py); oslDrawImageSimple(img); }
	#define oslSetImageTile(img,x0,y0,x1,y1)		{ (img)->offsetX0=(float)x0, (img)->offsetY0=(float)y0, (img)->offsetX1=(float)x1, (img)->offsetY1=(float)y1; (img)->stretchX = oslAbs((int)((float)((img)->offsetX1) - (float)((img)->offsetX0))), (img)->stretchY = oslAbs((int)((float)((img)->offsetY1) - (float)((img)->offsetY0))); }
	#define oslSetImageTileSize(img,x0,y0,x1,y1)	{ (img)->offsetX0=(float)(x0), (img)->offsetY0=(float)(y0), (img)->offsetX1=(float)(x0)+(float)(x1), (img)->offsetY1=(float)(y0)+(float)(y1), (img)->stretchX = (int)(x1), (img)->stretchY = (int)(y1); }
	#define oslResetImageTile(img)					{ (img)->offsetX0=0, (img)->offsetY0=0, (img)->offsetX1=(img)->sizeX, (img)->offsetY1=(img)->sizeY; (img)->stretchX = (img)->sizeX, (img)->stretchY = (img)->sizeY; }
	#define oslMirrorImageH(img)					{ float ___tmp;  ___tmp = (img)->offsetX0; (img)->offsetX0 = (img)->offsetX1; (img)->offsetX1 = ___tmp; }
	#define oslMirrorImageV(img)					{ float ___tmp;  ___tmp = (img)->offsetY0; (img)->offsetY0 = (img)->offsetY1; (img)->offsetY1 = ___tmp; }
#endif

#define oslCorrectImageHalfBorder(img)			((img)->offsetX0 = (img)->offsetX0 + 0.5f, (img)->offsetY0 = (img)->offsetY0 + 0.5f, (img)->offsetX1 = (img)->offsetX1 - 0.5f, (img)->offsetY1 = (img)->offsetY1 - 0.5f, img->stretchX--, img->stretchY--)
#define oslResetImageHalfBorder(img)			((img)->offsetX0 = (img)->offsetX0 - 0.5f, (img)->offsetY0 = (img)->offsetY0 - 0.5f, (img)->offsetX1 = (img)->offsetX1 + 0.5f, (img)->offsetY1 = (img)->offsetY1 + 0.5f, img->stretchX++, img->stretchY++)

#define oslGetDrawBuffer()			osl_curBuf

// *** Console ***
#ifdef PSP
#define oslPrintf(format...)		({ char __str[1000]; sprintf(__str , ##format); oslConsolePrint(__str); })
#define oslPrintf_xy(x,y, str, format...)		({			osl_consolePosX=x, osl_consolePosY=y;		\
															oslPrintf(str,##format); })
#else
#define oslPrintf(...)		{ char __str[1000]; sprintf(__str , __VA_ARGS__); oslConsolePrint(__str); }
#define oslPrintf_xy(x,y, ...)		{			osl_consolePosX=x, osl_consolePosY=y;		\
															oslPrintf(__VA_ARGS__); }
#endif

#define oslCls()		 	(oslClearScreen(0), oslMoveTo(0,0))
#define oslMoveTo(x,y)				(osl_consolePosX=x*osl_curFont->charWidths['0'], osl_consolePosY=y*osl_curFont->charHeight)

// *** Interface utilisateur ***
//Affiche un message si la condition est fausse
#ifdef PSP
#define oslDebug(format...)		({ char __str2[1000], __str[1000]; sprintf(__str2, "Debug (%s:%i,%s)",__FUNCTION__,__LINE__,__FILE__); sprintf(__str , ##format); oslMessageBox(__str, __str2, oslMake3Buttons(OSL_KEY_CROSS,OSL_MB_OK,OSL_KEY_TRIANGLE,OSL_MB_QUIT,0,0)); })
#define oslMake3Buttons(b1,a1,b2,a2,b3,a3)		((b1)|((a1)<<5)|((b2)<<9)|((a2)<<14)|((b3)<<18)|((a3)<<23))
#define oslWarning(format...)			({ char __str[1000]; sprintf(__str , ##format); oslMessageBox(__str, "Warning", oslMake3Buttons(OSL_KEY_CROSS,OSL_MB_OK,OSL_KEY_TRIANGLE,OSL_MB_QUIT,0,0)); })
#define oslFatalError(format...)		({ char __str[1000]; sprintf(__str , ##format); oslMessageBox(__str, "Fatal error", oslMake3Buttons(OSL_KEY_CROSS,OSL_MB_QUIT,0,0,0,0)); })
#else
#define oslDebug(...)		{ char __str2[1000], __str[1000]; sprintf(__str2, "Debug (%s:%i,%s)",__FUNCTION__,__LINE__,__FILE__); sprintf(__str , __VA_ARGS__); oslMessageBox(__str, __str2, oslMake3Buttons(OSL_KEY_CROSS,OSL_MB_OK,OSL_KEY_TRIANGLE,OSL_MB_QUIT,0,0)); }
#define oslMake3Buttons(b1,a1,b2,a2,b3,a3)		((b1)|((a1)<<5)|((b2)<<9)|((a2)<<14)|((b3)<<18)|((a3)<<23))
#define oslWarning(...)			{ char __str[1000]; sprintf(__str , __VA_ARGS__); oslMessageBox(__str, "Warning", oslMake3Buttons(OSL_KEY_CROSS,OSL_MB_OK,OSL_KEY_TRIANGLE,OSL_MB_QUIT,0,0)); }
#define oslFatalError(...)		{ char __str[1000]; sprintf(__str , __VA_ARGS__); oslMessageBox(__str, "Fatal error", oslMake3Buttons(OSL_KEY_CROSS,OSL_MB_QUIT,0,0,0,0)); }
#endif
#define oslAssert(cond)		({ if (!(cond)) { char __str[1000]; sprintf(__str , "This program encountered a fatal error and must be terminated.\n\nFile : %s:%i\nError: %s",__FILE__,__LINE__,""#cond); oslMessageBox(__str, "Fatal error", oslMake3Buttons(OSL_KEY_CROSS,OSL_MB_QUIT,0,0,0,0)); } })
#define oslResetScreenClipping()		oslSetScreenClipping(0, 0, osl_curBuf->sizeX, osl_curBuf->sizeY)

// *** Frameskip ***
#define oslSetMaxFrameskip(val) (osl_maxFrameskip = val)
#define oslSetVSync(val) (osl_vsyncEnabled = val)
#define oslSetFrameskip(val) (osl_frameskip = val)
#define oslSyncFrame()	oslSyncFrameEx(osl_frameskip,osl_maxFrameskip,osl_vsyncEnabled)

// *** Contrleur ***
#ifdef PSP
	#define oslSetKeyAutorepeat(keys,init,interval)		({ osl_keys->autoRepeatMask = keys; osl_keys->autoRepeatInit = init; osl_keys->autoRepeatInterval = interval; })
#else
	#define oslSetKeyAutorepeat(keys,init,interval)		{ osl_keys->autoRepeatMask = keys; osl_keys->autoRepeatInit = init; osl_keys->autoRepeatInterval = interval; }
#endif
#define oslSetKeyAutorepeatMask(mask)		(osl_keys->autoRepeatMask=mask)
#define oslSetKeyAutorepeatInit(value)		(osl_keys->autoRepeatInit=value)
#define oslSetKeyAutorepeatInterval(value)	(osl_keys->autoRepeatInterval=value)

// *** Console SONY ***
/*#define oslCls()								pspDebugScreenClear()
#define oslPrintf(str, format...)				pspDebugScreenPrintf(str,##format)
#define oslMoveTo(x,y)							pspDebugScreenSetXY(x,y)
#define oslPrintf_xy(x,y, str, format...)		({			oslMoveTo(x,y);		\
															oslPrintf(str,##format); })*/

/*
	Constantes
*/

// *** Gnral ***
//Discard: ne pas prendre en compte, None: aucun alpha (opaque)
enum {OSL_FX_NONE=0, OSL_FX_FLAT, OSL_FX_ALPHA, OSL_FX_ADD, OSL_FX_SUB};
#define OSL_FX_DEFAULT OSL_FX_RGBA
#define OSL_FX_OPAQUE OSL_FX_NONE
//Cumulable avec les autres pour dfinir l'utilisation du canal alpha.
#define OSL_FX_RGBA 0x100
//Coefficients alpha  trois canaux
#define OSL_FX_COLOR 0x1000
//Endroits o placer une image
enum {OSL_IN_VRAM=0, OSL_IN_RAM};
enum pixelFormats {OSL_PF_5650=GU_PSM_5650, OSL_PF_5551=GU_PSM_5551, OSL_PF_4444=GU_PSM_4444, OSL_PF_8888=GU_PSM_8888,
					OSL_PF_4BIT=GU_PSM_T4, OSL_PF_8BIT=GU_PSM_T8};
//Benchmark
enum {OSL_BENCH_INIT=0, OSL_BENCH_START, OSL_BENCH_END, OSL_BENCH_GET, OSL_BENCH_DISPLAY};
#define OSL_BENCH_SLOTS 8
//Formats de map
enum {OSL_MF_U16=1};
//Correspondance entre le n de bit et le code
enum {OSL_KEY_SELECT=1, OSL_KEY_START=4, OSL_KEY_UP=5, OSL_KEY_RIGHT=6, OSL_KEY_DOWN=7, OSL_KEY_LEFT=8, OSL_KEY_L=9, OSL_KEY_R=10,
		OSL_KEY_TRIANGLE=13, OSL_KEY_CIRCLE=14, OSL_KEY_CROSS=15, OSL_KEY_SQUARE=16, OSL_KEY_HOME=17, OSL_KEY_HOLD=18, OSL_KEY_NOTE=24};
enum {OSL_KEYMASK_SELECT=0x1, OSL_KEYMASK_START=0x8, OSL_KEYMASK_UP=0x10, OSL_KEYMASK_RIGHT=0x20, OSL_KEYMASK_DOWN=0x40, OSL_KEYMASK_LEFT=0x80, OSL_KEYMASK_L=0x100, OSL_KEYMASK_R=0x200,
		OSL_KEYMASK_TRIANGLE=0x1000, OSL_KEYMASK_CIRCLE=0x2000, OSL_KEYMASK_CROSS=0x4000, OSL_KEYMASK_SQUARE=0x8000, OSL_KEYMASK_HOME=0x10000, OSL_KEYMASK_HOLD=0x20000, OSL_KEYMASK_NOTE=0x800000};
//Actions dans la messagebox
enum {OSL_MB_OK=1, OSL_MB_CANCEL, OSL_MB_YES, OSL_MB_NO, OSL_MB_QUIT};
//Flags oslWriteImageFile. OSL_WRI_ALPHA -> crit le canal alpha
enum {OSL_WRI_ALPHA=1};

// *** Interne ***
#define OSL_SLICE_SIZE 64
#define OSL_DEFAULT_BUFFER (&osl_defaultBufferImage)
#define OSL_SECONDARY_BUFFER (&osl_secondaryBufferImage)
#define OSL_BENCH_SAMPLES 20


/*
	Variables externes (inaccessibles)
*/
//extern unsigned int osl_list[262144];
extern unsigned int *osl_list;
extern unsigned char *osl_vMemPtr ;
extern unsigned long osl_temp_texture[8*8];
extern int osl_gradientTextureSampling;
extern float osl_fsinus[361];
extern float osl_fcosinus[361];
extern const int osl_isinus[361];
extern const int osl_icosinus[361];
extern void *osl_curTexture, *osl_curPalette;
extern int osl_currentResolutionBPP;
//Drawbuffer (sur lequel on dessine), dispbuffer (affich  l'cran)
extern void *osl_curDrawBuf, *osl_curDispBuf;
extern int osl_maxFrameskip, osl_vsyncEnabled, osl_frameskip;
extern volatile int osl_vblCount, osl_vblCallCount, osl_skip;
//Couleur transparente utilise au chargement des images.
extern int osl_colorKeyEnabled, osl_colorKeyValue;
extern int osl_standByUnpermitted;
extern int (*osl_powerCallback)(int, int, void*);
extern int osl_currentAlphaEffect, osl_currentAlphaCoeff;

/*
	Variables accessible en lecture par l'utilisateur
*/
extern const int osl_pixelWidth[];
extern int osl_quit;
extern OSL_IMAGE osl_defaultBufferImage, osl_secondaryBufferImage, *osl_curBuf;
extern OSL_CONTROLLER *osl_keys;
extern OSL_CONTROLLER osl_intKeys;
extern OSL_IMAGE osl_defaultBufferImage;
extern int osl_bilinearFilterEnabled;

/*
	Variables accessible en lecture et criture par l'utilisateur
*/
//Peut tre mis  0 pour gagner de la place, mais ce n'est pas garanti que tout fonctionne (particulirement si le mode de texture n'est pas repeat).
extern int osl_alignBuffer;
//Numro de l'interruption VBLANK utilise
extern int osl_vblInterruptNumber;


/*
	Fonctions
*/
//PC only
#ifndef PSP
	extern void Debug(const char *format, ...);
#endif
//Gnral
extern void oslInit(int useOwnCallbacks);
extern void oslQuit();
extern void oslInitGfx(int pixelFormat, int bDoubleBuffer);
extern void oslStartDrawing();
extern void oslSyncDrawing();
extern void oslEndDrawing();
extern void oslWaitVSync();
extern void oslSwapBuffers();
extern void oslEndGfx();
extern void oslLockImage(OSL_IMAGE *img);
extern void oslUnlockImage(OSL_IMAGE *img);
#ifdef PSP
	extern inline void oslFlushDataCache();
#else
	extern void oslFlushDataCache();
#endif
extern void oslUncachePalette(OSL_PALETTE *pal);
extern int oslSyncFrameEx(int frameskip, int max_frameskip, int vsync);
extern void oslSetTransparentColor(OSL_COLOR color);
extern void oslDisableTransparentColor();
extern void oslShowNeoflashLogo();

//Maths
extern void oslSetupFTrigo();
extern float oslCos(int angle, int dist);
extern float oslSin(int angle, int dist);
extern int oslGetNextPower2(int val);

//Graphique::image
extern OSL_IMAGE *oslCreateImage(int larg, int haut, short location, short pixelFormat);
extern void oslDeleteImage(OSL_IMAGE *img);
extern OSL_IMAGE *oslCreateImageTile(OSL_IMAGE *img, int offsetX0, int offsetY0, int offsetX1, int offsetY1);
extern OSL_IMAGE *oslCreateImageTileSize(OSL_IMAGE *img, int offsetX0, int offsetY0, int width, int height);
extern void oslCopyImage(OSL_IMAGE *imgDst, OSL_IMAGE *imgSrc);
extern void oslSwizzleImage(OSL_IMAGE *imgDst, OSL_IMAGE *imgSrc);
extern void oslClearImage(OSL_IMAGE *img, int color);				//A tester!!!
//extern void oslUncacheImage(OSL_IMAGE *img);
extern OSL_IMAGE *oslCreateImageCopy(OSL_IMAGE *src, int newLocation);
extern OSL_IMAGE *oslCreateSwizzledImage(OSL_IMAGE *src, int newLocation);
//Gnrique
extern OSL_IMAGE *oslLoadImageFile(char *filename, int location, int pixelFormat);
extern int oslWriteImageFile(OSL_IMAGE *img, const char* filename, int flags);
//Spcialis
extern OSL_IMAGE *oslLoadImageFilePNG(char *filename, int location, int pixelFormat);
extern int oslWriteImageFilePNG(OSL_IMAGE *img, const char* filename, int flags);


//Graphique::palette
extern OSL_PALETTE *oslCreatePalette(int size, short pixelFormat);
extern OSL_PALETTE *oslLoadPalette(void *data, int size, short pixelFormat);

//Graphique::dessin
extern void oslDrawImage(OSL_IMAGE *img);
extern void oslDrawImageSimple(OSL_IMAGE *img);
extern void oslDrawLine(int x0, int y0, int x1, int y1, OSL_COLOR color);
extern void oslDrawRect(int x0, int y0, int x1, int y1, OSL_COLOR color);
extern void oslDrawFillRect(int x0, int y0, int x1, int y1, OSL_COLOR color);
extern void oslDrawGradientRect(int x0, int y0, int x1, int y1, OSL_COLOR c1, OSL_COLOR c2, OSL_COLOR c3, OSL_COLOR c4);

//Graphique::map
extern OSL_MAP *oslCreateMap(OSL_IMAGE *img, void *map_data, int tileX, int tileY, int mapSizeX, int mapSizeY, int map_format);
extern void oslDrawMap(OSL_MAP *m);
extern void oslDrawMapSimple(OSL_MAP *m);					//tileX, tileY, img->sizeX doivent tre des puissances de deux!

//Graphique::cran
extern void oslClearScreen(int backColor);
extern void oslSetScreenClipping(int x0, int y0, int x1, int y1);
extern void oslSetDrawBuffer(OSL_IMAGE *img);

//Graphique::alpha
extern void oslSetAlpha(int effect, int coeff);

//Graphique::interne
extern int oslVerifyStripBlit(OSL_IMAGE *img);
extern int oslConvertColor(int pfDst, int pfSrc, int color);
#ifdef PSP
	extern inline void oslSetTexture(OSL_IMAGE *img);
#else
	extern void oslSetTexture(OSL_IMAGE *img);
#endif
extern void oslSetBilinearFilter(int enabled);
extern void oslSwizzleTexture(u8* out, const u8* in, unsigned int width, unsigned int height);
extern void oslDrawTile(int u, int v, int x, int y, int tX, int tY);

//Interface utilisateur
extern void oslSystemMessage(const char *message);
extern unsigned int oslMessageBox(const char *text, const char *title, unsigned int flags);

//Benchmark
extern int oslBenchmarkTestEx(int startend, int slot);			//Permet de choisir un slot (0-3: user, 4:7: system)
extern int oslMeanBenchmarkTestEx(int startend, int slot);		//Benchmark systme sur une moyenne de 16 chantillons
extern void oslSysBenchmarkDisplay();

//Contrleur
extern OSL_CONTROLLER *oslReadKeys();
extern int oslWaitKey();
extern int oslKbhit();
extern void oslFlushKey();

//Interne
extern int sceDmacMemcpy(void *dest, const void *source, unsigned int size);				//Copie DMA
extern int sceDmacTryMemcpy(void *dest, const void *source, unsigned int size);				//Fonction SCE

#ifdef PSP
	#include "vfpu.h"
#endif
#include "text.h"

#ifdef __cplusplus
}
#endif

#endif
