#include "oslib.h"

OSL_FONT *osl_curFont=NULL;
OSL_FONT *osl_sceFont=NULL;
int osl_consolePosX=0, osl_consolePosY=0; //, osl_consoleOk=0;

const unsigned char osl_sceFont_data[]=		{
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x3c, 0x42, 0xa5, 0x81, 0xa5, 0x99, 0x42, 0x3c, 
	0x3c, 0x7e, 0xdb, 0xff, 0xff, 0xdb, 0x66, 0x3c, 
	0x36, 0x7f, 0x7f, 0x7f, 0x3e, 0x1c, 0x8, 0x0, 
	0x8, 0x1c, 0x3e, 0x7f, 0x3e, 0x1c, 0x8, 0x0, 
	0x8, 0x1c, 0x2a, 0x7f, 0x2a, 0x8, 0x1c, 0x0, 
	0x8, 0x1c, 0x3e, 0x7f, 0x7f, 0x8, 0x1c, 0x0, 
	0x0, 0x0, 0x0, 0xc, 0xc, 0x0, 0x0, 0x0, 
	0xff, 0xff, 0xff, 0xe7, 0xe7, 0xff, 0xff, 0xff, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xf0, 0xc0, 0xa0, 0x9e, 0x11, 0x11, 0x11, 0xe, 
	0x1c, 0x22, 0x22, 0x22, 0x1c, 0x8, 0x3e, 0x8, 
	0xc, 0x14, 0x24, 0x24, 0x14, 0x4, 0x7, 0x3, 
	0x3c, 0x24, 0x3c, 0x24, 0x24, 0x27, 0x3b, 0x18, 
	0x8, 0x2a, 0x1c, 0x77, 0x1c, 0x2a, 0x8, 0x0, 
	0x8, 0x8, 0x8, 0x3e, 0x8, 0x8, 0x8, 0x8, 
	0x8, 0x8, 0x8, 0xff, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xff, 0x8, 0x8, 0x8, 0x8, 
	0x8, 0x8, 0x8, 0xf, 0x8, 0x8, 0x8, 0x8, 
	0x8, 0x8, 0x8, 0xf8, 0x8, 0x8, 0x8, 0x8, 
	0x8, 0x8, 0x8, 0xff, 0x8, 0x8, 0x8, 0x8, 
	0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 
	0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xf8, 0x8, 0x8, 0x8, 0x8, 
	0x0, 0x0, 0x0, 0xf, 0x8, 0x8, 0x8, 0x8, 
	0x8, 0x8, 0x8, 0xf8, 0x0, 0x0, 0x0, 0x0, 
	0x8, 0x8, 0x8, 0xf, 0x0, 0x0, 0x0, 0x0, 
	0x81, 0x42, 0x24, 0x18, 0x18, 0x24, 0x42, 0x81, 
	0x80, 0x40, 0x20, 0x10, 0x8, 0x4, 0x2, 0x1, 
	0x1, 0x2, 0x4, 0x8, 0x10, 0x20, 0x40, 0x80, 
	0x0, 0x8, 0x8, 0xff, 0x8, 0x8, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x4, 0x4, 0x4, 0x4, 0x0, 0x0, 0x4, 0x0, 
	0xa, 0xa, 0xa, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xa, 0xa, 0x1f, 0xa, 0x1f, 0xa, 0xa, 0x0, 
	0x4, 0x1e, 0x5, 0xe, 0x14, 0xf, 0x4, 0x0, 
	0x3, 0x13, 0x8, 0x4, 0x2, 0x19, 0x18, 0x0, 
	0x2, 0x5, 0x2, 0x15, 0x9, 0x19, 0x6, 0x0, 
	0x8, 0x4, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x8, 0x4, 0x2, 0x2, 0x2, 0x4, 0x8, 0x0, 
	0x2, 0x4, 0x8, 0x8, 0x8, 0x4, 0x2, 0x0, 
	0x4, 0x15, 0xe, 0x4, 0xe, 0x15, 0x4, 0x0, 
	0x0, 0x4, 0x4, 0x1f, 0x4, 0x4, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x4, 0x2, 
	0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x6, 0x0, 
	0x0, 0x0, 0x10, 0x8, 0x4, 0x2, 0x1, 0x0, 
	0xe, 0x11, 0x19, 0x15, 0x13, 0x11, 0xe, 0x0, 
	0x4, 0x6, 0x5, 0x4, 0x4, 0x4, 0x1f, 0x0, 
	0xe, 0x11, 0x10, 0x8, 0x6, 0x1, 0x1f, 0x0, 
	0xe, 0x11, 0x10, 0xc, 0x10, 0x11, 0xe, 0x0, 
	0x8, 0xc, 0xa, 0x9, 0x1f, 0x8, 0x8, 0x0, 
	0x1f, 0x1, 0x7, 0x8, 0x10, 0x8, 0x7, 0x0, 
	0xc, 0x2, 0x1, 0xf, 0x11, 0x11, 0xe, 0x0, 
	0x1f, 0x11, 0x8, 0x4, 0x4, 0x4, 0x4, 0x0, 
	0xe, 0x11, 0x11, 0xe, 0x11, 0x11, 0xe, 0x0, 
	0xe, 0x11, 0x11, 0x1e, 0x10, 0x8, 0x6, 0x0, 
	0x0, 0x0, 0x4, 0x0, 0x0, 0x4, 0x0, 0x0, 
	0x0, 0x0, 0x4, 0x0, 0x0, 0x4, 0x4, 0x2, 
	0x18, 0xc, 0x6, 0x3, 0x6, 0xc, 0x18, 0x0, 
	0x0, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x0, 0x0, 
	0x3, 0x6, 0xc, 0x18, 0xc, 0x6, 0x3, 0x0, 
	0xe, 0x11, 0x10, 0x8, 0x4, 0x0, 0x4, 0x0, 
	0xe, 0x11, 0x10, 0x16, 0x15, 0x15, 0xe, 0x0, 
	0x4, 0xa, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x0, 
	0xf, 0x12, 0x12, 0xe, 0x12, 0x12, 0xf, 0x0, 
	0xc, 0x12, 0x1, 0x1, 0x1, 0x12, 0xc, 0x0, 
	0x7, 0xa, 0x12, 0x12, 0x12, 0xa, 0x7, 0x0, 
	0x1f, 0x1, 0x1, 0xf, 0x1, 0x1, 0x1f, 0x0, 
	0x1f, 0x1, 0x1, 0xf, 0x1, 0x1, 0x1, 0x0, 
	0xe, 0x11, 0x1, 0x1d, 0x11, 0x11, 0xe, 0x0, 
	0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x0, 
	0xe, 0x4, 0x4, 0x4, 0x4, 0x4, 0xe, 0x0, 
	0x1c, 0x8, 0x8, 0x8, 0x9, 0x9, 0x6, 0x0, 
	0x11, 0x9, 0x5, 0x3, 0x5, 0x9, 0x11, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1f, 0x0, 
	0x11, 0x1b, 0x15, 0x15, 0x11, 0x11, 0x11, 0x0, 
	0x11, 0x13, 0x13, 0x15, 0x19, 0x19, 0x11, 0x0, 
	0xe, 0x11, 0x11, 0x11, 0x11, 0x11, 0xe, 0x0, 
	0xf, 0x11, 0x11, 0xf, 0x1, 0x1, 0x1, 0x0, 
	0xe, 0x11, 0x11, 0x11, 0x15, 0x9, 0x16, 0x0, 
	0xf, 0x11, 0x11, 0xf, 0x5, 0x9, 0x11, 0x0, 
	0xe, 0x11, 0x1, 0xe, 0x10, 0x11, 0xe, 0x0, 
	0x1f, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x0, 
	0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0xe, 0x0, 
	0x11, 0x11, 0x11, 0x11, 0xa, 0xa, 0x4, 0x0, 
	0x11, 0x11, 0x11, 0x15, 0x15, 0x1b, 0x11, 0x0, 
	0x11, 0x11, 0xa, 0x4, 0xa, 0x11, 0x11, 0x0, 
	0x11, 0x11, 0x11, 0xe, 0x4, 0x4, 0x4, 0x0, 
	0x1f, 0x10, 0x8, 0x4, 0x2, 0x1, 0x1f, 0x0, 
	0xe, 0x2, 0x2, 0x2, 0x2, 0x2, 0xe, 0x0, 
	0x0, 0x0, 0x1, 0x2, 0x4, 0x8, 0x10, 0x0, 
	0xe, 0x8, 0x8, 0x8, 0x8, 0x8, 0xe, 0x0, 
	0x4, 0xa, 0x11, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x0, 
	0x2, 0x4, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0xe, 0x10, 0x1e, 0x11, 0x1e, 0x0, 
	0x1, 0x1, 0xd, 0x13, 0x11, 0x13, 0xd, 0x0, 
	0x0, 0x0, 0xe, 0x11, 0x1, 0x11, 0xe, 0x0, 
	0x10, 0x10, 0x16, 0x19, 0x11, 0x19, 0x16, 0x0, 
	0x0, 0x0, 0xe, 0x11, 0x1f, 0x1, 0xe, 0x0, 
	0x8, 0x14, 0x4, 0x1f, 0x4, 0x4, 0x4, 0x0, 
	0x0, 0x0, 0x16, 0x19, 0x19, 0x16, 0x10, 0xe, 
	0x1, 0x1, 0xf, 0x11, 0x11, 0x11, 0x11, 0x0, 
	0x4, 0x0, 0x6, 0x4, 0x4, 0x4, 0xe, 0x0, 
	0x8, 0x0, 0xc, 0x8, 0x8, 0x8, 0x9, 0x6, 
	0x2, 0x2, 0x12, 0xa, 0x6, 0xa, 0x12, 0x0, 
	0x6, 0x4, 0x4, 0x4, 0x4, 0x4, 0xe, 0x0, 
	0x0, 0x0, 0xb, 0x15, 0x15, 0x15, 0x15, 0x0, 
	0x0, 0x0, 0xd, 0x13, 0x11, 0x11, 0x11, 0x0, 
	0x0, 0x0, 0xe, 0x11, 0x11, 0x11, 0xe, 0x0, 
	0x0, 0x0, 0xd, 0x13, 0x13, 0xd, 0x1, 0x1, 
	0x0, 0x0, 0x16, 0x19, 0x19, 0x16, 0x10, 0x10, 
	0x0, 0x0, 0xd, 0x13, 0x1, 0x1, 0x1, 0x0, 
	0x0, 0x0, 0x1e, 0x1, 0xf, 0x10, 0xf, 0x0, 
	0x2, 0x2, 0xf, 0x2, 0x2, 0x12, 0xc, 0x0, 
	0x0, 0x0, 0x9, 0x9, 0x9, 0x9, 0x16, 0x0, 
	0x0, 0x0, 0x11, 0x11, 0x11, 0xa, 0x4, 0x0, 
	0x0, 0x0, 0x11, 0x15, 0x15, 0x15, 0xa, 0x0, 
	0x0, 0x0, 0x11, 0xa, 0x4, 0xa, 0x11, 0x0, 
	0x0, 0x0, 0x11, 0x11, 0x19, 0x16, 0x10, 0xe, 
	0x0, 0x0, 0x1f, 0x8, 0x4, 0x2, 0x1f, 0x0, 
	0x18, 0x4, 0x4, 0x2, 0x4, 0x4, 0x18, 0x0, 
	0x4, 0x4, 0x4, 0x0, 0x4, 0x4, 0x4, 0x0, 
	0x3, 0x4, 0x4, 0x8, 0x4, 0x4, 0x3, 0x0, 
	0x2, 0x15, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x4, 0xa, 0x1f, 0x0, 0x0, 0x0, 
	0xe, 0x11, 0x1, 0x1, 0x11, 0xe, 0x4, 0x6, 
	0x9, 0x0, 0x0, 0x9, 0x9, 0x9, 0x16, 0x0, 
	0x8, 0x4, 0xe, 0x11, 0x1f, 0x1, 0xe, 0x0, 
	0x4, 0xa, 0xe, 0x10, 0x1e, 0x11, 0x1e, 0x0, 
	0x12, 0x0, 0xe, 0x10, 0x1e, 0x11, 0x1e, 0x0, 
	0x4, 0x8, 0xe, 0x10, 0x1e, 0x11, 0x1e, 0x0, 
	0x4, 0x0, 0xe, 0x10, 0x1e, 0x11, 0x1e, 0x0, 
	0x0, 0xe, 0x1, 0x1, 0x1, 0xe, 0x8, 0x6, 
	0x4, 0xa, 0xe, 0x11, 0x1f, 0x1, 0xe, 0x0, 
	0xa, 0x0, 0xe, 0x11, 0x1f, 0x1, 0xe, 0x0, 
	0x4, 0x8, 0xe, 0x11, 0x1f, 0x1, 0xe, 0x0, 
	0xa, 0x0, 0x0, 0x6, 0x4, 0x4, 0xe, 0x0, 
	0x4, 0xa, 0x0, 0x6, 0x4, 0x4, 0xe, 0x0, 
	0x2, 0x4, 0x0, 0x6, 0x4, 0x4, 0xe, 0x0, 
	0xa, 0x0, 0x4, 0xa, 0x11, 0x1f, 0x11, 0x0, 
	0x4, 0x0, 0x4, 0xa, 0x11, 0x1f, 0x11, 0x0, 
	0x8, 0x4, 0x1f, 0x1, 0xf, 0x1, 0x1f, 0x0, 
	0x0, 0x0, 0x36, 0x48, 0x7e, 0x9, 0x76, 0x0, 
	0x7c, 0xa, 0x9, 0x39, 0xf, 0x9, 0x79, 0x0, 
	0x6, 0x9, 0x0, 0x6, 0x9, 0x9, 0x6, 0x0, 
	0x9, 0x0, 0x0, 0x6, 0x9, 0x9, 0x6, 0x0, 
	0x2, 0x4, 0x0, 0x6, 0x9, 0x9, 0x6, 0x0, 
	0x2, 0x5, 0x0, 0x5, 0x5, 0x5, 0xa, 0x0, 
	0x2, 0x4, 0x0, 0x5, 0x5, 0x5, 0xa, 0x0, 
	0x9, 0x0, 0x9, 0x9, 0xd, 0xa, 0x8, 0x7, 
	0xa, 0x0, 0xe, 0x11, 0x11, 0x11, 0xe, 0x0, 
	0xa, 0x0, 0x11, 0x11, 0x11, 0x11, 0xe, 0x0, 
	0x4, 0x4, 0x1e, 0x1, 0x1, 0x1e, 0x4, 0x4, 
	0x18, 0x24, 0x4, 0x1f, 0x4, 0x47, 0x3a, 0x0, 
	0x11, 0xa, 0x4, 0x1f, 0x4, 0x1f, 0x4, 0x0, 
	0x3, 0x5, 0x5, 0x13, 0x39, 0x11, 0x11, 0x31, 
	0x18, 0x4, 0x4, 0x1f, 0x4, 0x4, 0x4, 0x2, 
	0x8, 0x4, 0xe, 0x10, 0x1e, 0x11, 0x1e, 0x0, 
	0x8, 0x4, 0x0, 0x6, 0x4, 0x4, 0xe, 0x0, 
	0x4, 0x2, 0x0, 0x6, 0x9, 0x9, 0x6, 0x0, 
	0x4, 0x2, 0x0, 0x9, 0x9, 0x9, 0x16, 0x0, 
	0xa, 0x5, 0x0, 0x5, 0xb, 0x9, 0x9, 0x0, 
	0x14, 0xa, 0x0, 0x13, 0x15, 0x19, 0x11, 0x0, 
	0x0, 0xe, 0x10, 0x1e, 0x11, 0x1e, 0x0, 0x1f, 
	0x0, 0x6, 0x9, 0x9, 0x9, 0x6, 0x0, 0xf, 
	0x4, 0x0, 0x4, 0x2, 0x1, 0x11, 0xe, 0x0, 
	0x0, 0x0, 0x0, 0x1f, 0x1, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1f, 0x10, 0x10, 0x0, 0x0, 
	0x21, 0x11, 0x9, 0x15, 0x2a, 0x21, 0x10, 0x38, 
	0x21, 0x11, 0x9, 0x15, 0x1a, 0x15, 0x3c, 0x10, 
	0x4, 0x0, 0x0, 0x4, 0x4, 0x4, 0x4, 0x0, 
	0x0, 0x0, 0x24, 0x12, 0x9, 0x12, 0x24, 0x0, 
	0x0, 0x0, 0x9, 0x12, 0x24, 0x12, 0x9, 0x0, 
	0x14, 0xa, 0x4, 0xa, 0x11, 0x1f, 0x11, 0x0, 
	0x14, 0xa, 0xe, 0x10, 0x1e, 0x11, 0x1e, 0x0, 
	0x14, 0xa, 0x0, 0xe, 0x4, 0x4, 0xe, 0x0, 
	0x14, 0xa, 0x0, 0x4, 0x4, 0x4, 0xe, 0x0, 
	0x14, 0xa, 0x0, 0xe, 0x11, 0x11, 0xe, 0x0, 
	0xa, 0x5, 0x0, 0x6, 0x9, 0x9, 0x6, 0x0, 
	0x14, 0xa, 0x0, 0x11, 0x11, 0x11, 0xe, 0x0, 
	0xa, 0x5, 0x0, 0x5, 0x5, 0x5, 0xa, 0x0, 
	0x3f, 0x12, 0x12, 0x12, 0x17, 0x10, 0xa, 0x4, 
	0x0, 0xa, 0x0, 0xa, 0xa, 0xa, 0x8, 0x4, 
	0x3, 0x22, 0x13, 0x2a, 0x37, 0x2a, 0x79, 0x20, 
	0x8, 0x15, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x4, 0xa, 0x11, 0xa, 0x4, 0x0, 0x0, 
	0x11, 0x8, 0x4, 0x2, 0x1, 0x14, 0x0, 0x0, 
	0x3e, 0x15, 0x15, 0x16, 0x14, 0x14, 0x14, 0x0, 
	0x1c, 0x2, 0xc, 0x12, 0x12, 0xc, 0x10, 0xe, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 
	0xf, 0xf, 0xf, 0xf, 0xf0, 0xf0, 0xf0, 0xf0, 
	0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3c, 0x3c, 0x0, 0x0, 0x0, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0xf0, 0xf0, 0xf0, 0xf0, 0xf, 0xf, 0xf, 0xf, 
	0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 
	0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 
	0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 
	0x88, 0x44, 0x22, 0x11, 0x88, 0x44, 0x22, 0x11, 
	0x11, 0x22, 0x44, 0x88, 0x11, 0x22, 0x44, 0x88, 
	0x7f, 0x3e, 0x1c, 0x8, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x1c, 0x3e, 0x7f, 
	0x1, 0x3, 0x7, 0xf, 0x7, 0x3, 0x1, 0x0, 
	0x80, 0xc0, 0xe0, 0xf0, 0xe0, 0xc0, 0x80, 0x0, 
	0xff, 0x7e, 0x3c, 0x18, 0x18, 0x3c, 0x7e, 0xff, 
	0x81, 0xc3, 0xe7, 0xff, 0xff, 0xe7, 0xc3, 0x81, 
	0xf, 0xf, 0xf, 0xf, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0xf0, 0xf0, 0xf0, 0xf0, 
	0xf0, 0xf0, 0xf0, 0xf0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0xf, 0xf, 0xf, 0xf, 
	0xcc, 0xcc, 0x33, 0x33, 0xcc, 0xcc, 0x33, 0x33, 
	0x0, 0x4, 0x4, 0xa, 0xa, 0x11, 0x1f, 0x0, 
	0x4, 0x4, 0xe, 0x4, 0xe, 0x4, 0x4, 0x0, 
	0x0, 0x0, 0x0, 0xa, 0x11, 0x15, 0xa, 0x0, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 
	0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 
	0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 
	0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x16, 0x9, 0x9, 0x9, 0x16, 0x0, 
	0xc, 0x12, 0x12, 0xe, 0x12, 0x12, 0xe, 0x3, 
	0x1f, 0x11, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1f, 0xa, 0xa, 0xa, 0xa, 0xa, 0x19, 0x0, 
	0x1f, 0x11, 0x2, 0x4, 0x2, 0x11, 0x1f, 0x0, 
	0x0, 0x0, 0x1e, 0x9, 0x9, 0x9, 0x6, 0x0, 
	0x0, 0xa, 0xa, 0xa, 0xa, 0x16, 0x1, 0x1, 
	0x0, 0xa, 0x5, 0x4, 0x4, 0x4, 0x4, 0x0, 
	0x1f, 0x4, 0xe, 0x15, 0x15, 0xe, 0x4, 0x1f, 
	0x4, 0xa, 0x11, 0x1f, 0x11, 0xa, 0x4, 0x0, 
	0xe, 0x11, 0x11, 0x11, 0xa, 0xa, 0x1b, 0x0, 
	0xc, 0x2, 0x2, 0x4, 0xa, 0xa, 0xa, 0x4, 
	0x0, 0x0, 0x0, 0xa, 0x15, 0x15, 0xa, 0x0, 
	0x10, 0xe, 0x15, 0x15, 0x15, 0xe, 0x1, 0x0, 
	0x1c, 0x2, 0x1, 0x1f, 0x1, 0x2, 0x1c, 0x0, 
	0xe, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0, 
	0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x0, 
	0x4, 0x4, 0x1f, 0x4, 0x4, 0x0, 0x1f, 0x0, 
	0x3, 0xc, 0x10, 0xc, 0x3, 0x0, 0x1f, 0x0, 
	0x18, 0x6, 0x1, 0x6, 0x18, 0x0, 0x1f, 0x0, 
	0x8, 0x14, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x5, 0x2, 
	0x0, 0x4, 0x0, 0x1f, 0x0, 0x4, 0x0, 0x0, 
	0x0, 0xa, 0x5, 0x0, 0xa, 0x5, 0x0, 0x0, 
	0x0, 0x18, 0x24, 0x24, 0x18, 0x0, 0x0, 0x0, 
	0x0, 0xc, 0x1e, 0x1e, 0xc, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0x0, 0x0, 
	0x7c, 0x4, 0x4, 0x4, 0x5, 0x6, 0x4, 0x0, 
	0x5, 0xa, 0xa, 0xa, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x5, 0x4, 0x2, 0x7, 0x0, 0x0, 0x0, 
	0x0, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
};

OSL_FONTINFO osl_sceFontInfo=		{
	(void*)osl_sceFont_data,				// Fonte Sony Computer Entertainment
	1,										// 1 bit par pixel
	NULL,									// Proportionnelle
	7, 8, 1,								// 7x8 (1 octet par ligne)
};

void oslDrawChar1BitToImage(OSL_IMAGE *img, int x0, int y0, int w, int h, int width, int bitPlanes, const unsigned char *font)
{
	unsigned char v, t, *data;
	int x,xx,y;
	for (y=0;y<h;y++)
	{
		data = (u8*)oslGetImageLine(img, y+y0)+(x0>>1);
		for (xx=0;xx<width;)			{
			v = *font++;
			for (x=0;x<8;x+=bitPlanes)
			{
				if (xx < w)			{
					t = v & ((1 << bitPlanes) - 1);
					if (t)			{
						if ((xx + x0) & 1)
							*data++ |= t<<4;
						else
							*data |= t;
					}
					else		{
						if ((xx + x0) & 1)
							data++;
					}
				}
				v >>= bitPlanes;
				xx++;
			}
		}
	}
}

OSL_FONT *oslLoadFont(OSL_FONTINFO *fi)
{
	OSL_FONT *f;
	int i, x, y;
	const int pixelplanewidth[4]={3, 2, 2, 1};
	
	f = (OSL_FONT*)malloc(sizeof(OSL_FONT));
	if (!f)
		return NULL;
	//Liste des tailles
	f->charWidths = (u8*)malloc(256*sizeof(char));
	if (!f->charWidths)		{
		free(f);
		return NULL;
	}
	if (fi->charWidths)		{
		//Rutilise les tailles fournies
		for (i=0;i<256;i++)
			f->charWidths[i] = fi->charWidths[i];
//		f->charWidths = fi->charWidths;
		f->isCharWidthConstant = 0;
	}
	else		{
		//Remplit la table avec les mmes tailles
		for (i=0;i<256;i++)
			f->charWidths[i] = fi->charWidth;
		f->isCharWidthConstant = 1;
	}
	//Position des caractres (pour les fontes non proportionnelles)
	f->charPositions = (u16*)malloc(256*sizeof(short));
	if (!f->charPositions)		{
		free(f->charWidths);
		free(f);
		return NULL;
	}
	f->addedSpace = fi->addedSpace;
	x = y = 0;
	for (i=0;i<256;i++)
	{
		if (x + f->charWidths[i] + f->addedSpace >= OSL_TEXT_TEXWIDTH)			{
			//Prochaine ligne
			x = 0;
			y ++;
		}
		f->charPositions[i] = x + (y<<OSL_TEXT_TEXDECAL);
		x += f->charWidths[i] + f->addedSpace;
	}

	//16x16 caractres
	f->img = oslCreateImage(512, (y+1)*fi->charHeight, OSL_IN_RAM, OSL_PF_4BIT);
	if (!f->img)		{
		free(f->charPositions);
		free(f->charWidths);
		free(f);
		return NULL;
	}
	//La palette
	f->img->palette = oslCreatePalette(16, OSL_PF_8888);
	if (!f->img->palette)		{
		free(f->charPositions);
		free(f->charWidths);
		free(f);
		oslDeleteImage(f->img);
		return NULL;
	}
	((unsigned long*)f->img->palette->data)[0] = RGB(0,0,0);
	((unsigned long*)f->img->palette->data)[1] = RGB(255,255,255);
	//Vide directement le cache
	sceKernelDcacheWritebackInvalidateRange(f->img->palette->data, 16*4);

	f->charHeight = fi->charHeight;
	memset(f->img->data, 0, f->img->totalSize);
	//Dessine les caractres sur le buffer
	for (i=0;i<256;i++)		{
		oslDrawChar1BitToImage(f->img, OSL_TEXT_CHARPOSXY(f, i),
			f->charWidths[i] + f->addedSpace, f->charHeight, fi->lineWidth << pixelplanewidth[fi->pixelFormat - 1],
			fi->pixelFormat, (u8*)fi->fontdata+i*fi->lineWidth*fi->charHeight);
	}
	//Pareil, vide direct le cache
	sceKernelDcacheWritebackInvalidateRange(f->img->data, f->img->totalSize);
	return f;
}

OSL_FONT *oslLoadFontFile(const char *filename)		{
	OSL_FONTINFO fi;
	OSL_FONT_FORMAT_HEADER fh;
	SceUID f;
	OSL_FONT *font = NULL;
	unsigned char tcTaillesCar[256], *tcCaracteres;
	
	f = sceIoOpen(filename, PSP_O_RDONLY, 0777);
	if (f >= 0)			{
		//Lit l'en-tte de la fonte
		sceIoRead(f, &fh, sizeof(fh));
		//Vrifie l'en-tte
		if (!strcmp(fh.strVersion, "OSLFont v01"))		{
			fi.pixelFormat = fh.pixelFormat;
			//VERIFIER 1 <= PIXELFORMAT <= 4
			if (fh.variableWidth)		{
				sceIoRead(f, tcTaillesCar, 256 * sizeof(unsigned char));
				fi.charWidths = tcTaillesCar;
			}
			else
				fi.charWidths = NULL;
			fi.charWidth = fh.charWidth;
			fi.charHeight = fh.charHeight;
			fi.lineWidth = fh.lineWidth;
			fi.addedSpace = fh.addedSpace;
			//Lit les donnes des caractres
			tcCaracteres = (u8*)malloc(fh.lineWidth*fi.charHeight*256);
			if (sceIoRead(f, tcCaracteres, fh.lineWidth*fi.charHeight*256) > 0)			{
				fi.fontdata = tcCaracteres;
				font = oslLoadFont(&fi);
			}
			free(tcCaracteres);
		}
		sceIoClose(f);
	}
	return font;
}

void oslDeleteFont(OSL_FONT *f)		{
	oslDeleteImage(f->img);
	free(f->charPositions);
	free(f->charWidths);
	free(f);
}

void oslDrawChar(int x, int y, unsigned char c)
{
	if (!osl_curFont)
		return;
	oslSetTexture(osl_curFont->img);
	//Dessine le caractre
	oslDrawTile(OSL_TEXT_CHARPOSXY(osl_curFont, c), x, y, osl_curFont->charWidths[c] + osl_curFont->addedSpace, osl_curFont->charHeight);
}

void oslDrawString(int x, int y, const char *str)
{
	unsigned char c;
	if (!osl_curFont)
		return;
	oslSetTexture(osl_curFont->img);
	while(*str)			{
		c = *(unsigned char*)str++;
		oslDrawTile(OSL_TEXT_CHARPOSXY(osl_curFont, c), x, y, osl_curFont->charWidths[c] + osl_curFont->addedSpace, osl_curFont->charHeight);
		x += osl_curFont->charWidths[c];
	}
}

void oslDrawTextBox(int x0, int y0, int x1, int y1, const char *text, int format)
{
	int x,y, x2;
	unsigned char c;
	const char *text2;
	x = x0;
	y = y0;
	while(*text)		{
		c = *text;
		if (c == ' ')
		{
			text2 = text;
			x2 = x;
			do		{
				x2 += osl_curFont->charWidths[(int)(*text2++)];
				if (x2 > x1)		{
					text++;
					goto newline;
				}
			} while(*text2 != '\n' && *text2 != ' ' && *text2);
		}
		if (x + osl_curFont->charWidths[c] > x1 || *text=='\n')			{
newline:
			//Prochaine ligne
			x = x0;
			y += osl_curFont->charHeight;
			//Trop bas -> termin
			if (y + osl_curFont->charHeight > y1)
				break;
			//Retour -> saute
			if (*text == '\n')
				text++;
			continue;
		}
		oslDrawChar(x,y,c);
		x += osl_curFont->charWidths[c];
		text++;
	}
}

void oslInitConsole()
{
	//Charge et utilise la fonte systme
	if (!osl_sceFont)
		osl_sceFont = oslLoadFont(&osl_sceFontInfo);
	oslSetFont(osl_sceFont);
	oslCls();
//	osl_consoleOk=1;
}

void oslMoveMem(void *dst, void *src, int size)
{
	unsigned long *fdst=(unsigned long*)dst, *fsrc=(unsigned long*)src;
	while(size > 0)			{
		*fdst++ = *fsrc++;
		size -= 4;
	}
}

void oslConsolePrint(const char *str)
{
	unsigned char c;
//	if (!osl_consoleOk)
//		return;
	while(*str)
	{
		c = *(unsigned char*)str++;
		if (c!='\n')			{
			oslDrawChar(osl_consolePosX, osl_consolePosY, c);
			osl_consolePosX += osl_curFont->charWidths[c];
		}
		//A droite de l'cran
		if (osl_consolePosX+7 > osl_curBuf->sizeX || c=='\n')			{
			osl_consolePosY += osl_curFont->charHeight;
			//[MARCHE PAS, TESTER] Trop bas -> dfile
			if (osl_consolePosY + osl_curFont->charHeight > osl_curBuf->sizeY)		{
				osl_consolePosY -= osl_curFont->charHeight;
				oslSyncDrawing();
				oslMoveMem(oslGetUncachedPtr(oslGetImageLine(osl_curBuf, 0)), oslGetUncachedPtr(oslGetImageLine(osl_curBuf, osl_curFont->charHeight)), osl_curBuf->totalSize-(int)oslGetImageLine(osl_curBuf, osl_curFont->charHeight));
				oslFlushDataCache();
				oslDrawFillRect(0, osl_consolePosY, osl_curBuf->sizeX, osl_curBuf->sizeY, 0);
			}
			osl_consolePosX = 0;
		}
	}
}

void oslSetTextColor(OSL_COLOR color)			{
	if (!osl_curFont)
		return;
	oslSyncDrawing();
	((unsigned long*)osl_curFont->img->palette->data)[1] = color;
	osl_curPalette = NULL;
	sceKernelDcacheWritebackInvalidateRange(osl_curFont->img->palette->data, 16*4);
}

void oslSetBkColor(OSL_COLOR color)			{
	if (!osl_curFont)
		return;
	oslSyncDrawing();
	((unsigned long*)osl_curFont->img->palette->data)[0] = color;
	osl_curPalette = NULL;
	sceKernelDcacheWritebackInvalidateRange(osl_curFont->img->palette->data, 16*4);
}


