#include "vfpu.h"

float vfpu_vars[4] __attribute__((aligned(64)));

float vfpu_add(float f1, float f2)
{
   vfpu_vars[0] = f1;
   vfpu_vars[1] = f2;
   register void *ptr __asm ("a0") = vfpu_vars; 
   __asm__ volatile ( 
      cgen_asm(lv_s(0, 0, R_a0, 0))
      cgen_asm(lv_s(1, 1, R_a0, 0))
      cgen_asm(vadd_s(124, 0, 1))
      cgen_asm(sv_q(31, 0 * 4, R_a0, 0)) 
   : "=r"(ptr) : "r"(ptr) : "memory"); 
   return vfpu_vars[0];
}

float vfpu_sub(float f1, float f2)
{
   vfpu_vars[0] = f1;
   vfpu_vars[1] = f2;
   register void *ptr __asm ("a0") = vfpu_vars; 
   __asm__ volatile ( 
      cgen_asm(lv_s(0, 0, R_a0, 0))
      cgen_asm(lv_s(1, 1, R_a0, 0))
      cgen_asm(vsub_s(124, 0, 1))
      cgen_asm(sv_q(31, 0 * 4, R_a0, 0)) 
   : "=r"(ptr) : "r"(ptr) : "memory"); 
   return vfpu_vars[0];
}

int vfpu_isubf(float f1, float f2)
{
   vfpu_vars[0] = f1;
   vfpu_vars[1] = f2;
   register void *ptr __asm ("a0") = vfpu_vars; 
   __asm__ volatile ( 
      cgen_asm(lv_s(0, 0, R_a0, 0))
      cgen_asm(lv_s(1, 1, R_a0, 0))
      cgen_asm(vsub_s(2, 0, 1))
      cgen_asm(vf2in_s(124, 2, 0))
      cgen_asm(sv_q(31, 0 * 4, R_a0, 0)) 
   : "=r"(ptr) : "r"(ptr) : "memory"); 
   return *(int*)ptr;
}

int vfpu_f2i(float v)
{
   vfpu_vars[0] = v;
   register void *ptr __asm ("a0") = vfpu_vars; 
   __asm__ volatile (
      cgen_asm(lv_s(0, 0, R_a0, 0))
      cgen_asm(vf2in_s(124, 0, 0))
      cgen_asm(sv_q(31, 0 * 4, R_a0, 0)) 
   : "=r"(ptr) : "r"(ptr) : "memory"); 
   return *(int*)ptr;
}

//Int to float
#define vi2f_s(vfpu_rd,vfpu_rs,scale) (0xd2800000 | ((scale) << 16) | ((vfpu_rs) << 8) | (vfpu_rd)) 

float vfpu_i2f(int v)
{
   register void *ptr __asm ("a0") = vfpu_vars;
   *(int*)ptr = v;
   __asm__ volatile (
      cgen_asm(lv_s(0, 0, R_a0, 0))
      cgen_asm(vi2f_s(124, 0, 0))
      cgen_asm(sv_q(31, 0 * 4, R_a0, 0)) 
   : "=r"(ptr) : "r"(ptr) : "memory"); 
   return vfpu_vars[0];
}

float vfpu_mul(float f1, float f2)
{
   vfpu_vars[0] = f1;
   vfpu_vars[1] = f2;
   register void *ptr __asm ("a0") = vfpu_vars; 
   __asm__ volatile ( 
      cgen_asm(lv_s(0, 0, R_a0, 0))
      cgen_asm(lv_s(1, 1, R_a0, 0))
      cgen_asm(vmul_s(124, 0, 1))
      cgen_asm(sv_q(31, 0 * 4, R_a0, 0)) 
   : "=r"(ptr) : "r"(ptr) : "memory"); 
   return vfpu_vars[0];
}

float vfpu_div(float f1, float f2)
{
   vfpu_vars[0] = f1;
   vfpu_vars[1] = f2;
   register void *ptr __asm ("a0") = vfpu_vars; 
   __asm__ volatile ( 
      cgen_asm(lv_s(0, 0, R_a0, 0))
      cgen_asm(lv_s(1, 1, R_a0, 0))
      cgen_asm(vdiv_s(124, 0, 1))
      cgen_asm(sv_q(31, 0 * 4, R_a0, 0)) 
   : "=r"(ptr) : "r"(ptr) : "memory"); 
   return vfpu_vars[0];
}

float vfpu_sini(int f1, int f2)
{
   register void *ptr __asm ("a0") = vfpu_vars; 
   *(int*)ptr = f1;
   *((int*)ptr+1) = f2;
   vfpu_vars[2] = 90;
   __asm__ volatile ( 
      cgen_asm(lv_s(0, 0, R_a0, 0))
      cgen_asm(lv_s(1, 1, R_a0, 0))
      cgen_asm(lv_s(2, 2, R_a0, 0))
      cgen_asm(vi2f_s(0, 0, 0))
      cgen_asm(vi2f_s(1, 1, 0))
      cgen_asm(vdiv_s(0, 0, 2))					//f1/90
      cgen_asm(vsin_s(124, 0))					//sin(f1)
      cgen_asm(vmul_s(124, 124, 1))				//f1*f2
      cgen_asm(sv_q(31, 0 * 4, R_a0, 0)) 
   : "=r"(ptr) : "r"(ptr) : "memory"); 
   return vfpu_vars[0];
}

float vfpu_cosi(int f1, int f2)
{
   register void *ptr __asm ("a0") = vfpu_vars; 
   *(int*)ptr = f1;
   *((int*)ptr+1) = f2;
   vfpu_vars[2] = 90;
   __asm__ volatile ( 
      cgen_asm(lv_s(0, 0, R_a0, 0))
      cgen_asm(lv_s(1, 1, R_a0, 0))
      cgen_asm(lv_s(2, 2, R_a0, 0))
      cgen_asm(vi2f_s(0, 0, 0))
      cgen_asm(vi2f_s(1, 1, 0))
      cgen_asm(vdiv_s(0, 0, 2))					//f1/90
      cgen_asm(vcos_s(124, 0))					//cos(f1)
      cgen_asm(vmul_s(124, 124, 1))				//f1*f2
      cgen_asm(sv_q(31, 0 * 4, R_a0, 0)) 
   : "=r"(ptr) : "r"(ptr) : "memory"); 
   return vfpu_vars[0];
}

/*int vfpu_icos(int f1, int f2)
{
   *(int*)ptr = f1;
   *((int*)ptr+1) = f2;
   vfpu_vars[2] = 90;
   register void *ptr __asm ("a0") = vfpu_vars; 
   __asm__ volatile ( 
      cgen_asm(lv_s(0, 0, R_a0, 0))
      cgen_asm(lv_s(1, 1, R_a0, 0))
      cgen_asm(lv_s(2, 2, R_a0, 0))
      cgen_asm(vdiv_s(0, 0, 2))					//f1/90
      cgen_asm(vcos_s(124, 0))					//cos(f1)
      cgen_asm(vmul_s(124, 124, 1))				//f1*f2
      cgen_asm(sv_q(31, 0 * 4, R_a0, 0)) 
   : "=r"(ptr) : "r"(ptr) : "memory"); 
   return *(int*)ptr;
}*/
